/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.codec;

import com.github.jasync.sql.db.exceptions.BufferNotFullyConsumedException;
import com.github.jasync.sql.db.exceptions.NegativeMessageSizeException;
import com.github.jasync.sql.db.exceptions.ParserNotAvailableException;
import com.github.jasync.sql.db.mysql.codec.DecoderRegistry;
import com.github.jasync.sql.db.mysql.codec.MySQLFrameDecoderKt;
import com.github.jasync.sql.db.mysql.decoder.AuthenticationSwitchRequestDecoder;
import com.github.jasync.sql.db.mysql.decoder.ColumnDefinitionDecoder;
import com.github.jasync.sql.db.mysql.decoder.ColumnProcessingFinishedDecoder;
import com.github.jasync.sql.db.mysql.decoder.EOFMessageDecoder;
import com.github.jasync.sql.db.mysql.decoder.ErrorDecoder;
import com.github.jasync.sql.db.mysql.decoder.HandshakeV10Decoder;
import com.github.jasync.sql.db.mysql.decoder.MessageDecoder;
import com.github.jasync.sql.db.mysql.decoder.OkDecoder;
import com.github.jasync.sql.db.mysql.decoder.ParamAndColumnProcessingFinishedDecoder;
import com.github.jasync.sql.db.mysql.decoder.ParamProcessingFinishedDecoder;
import com.github.jasync.sql.db.mysql.decoder.PreparedStatementPrepareResponseDecoder;
import com.github.jasync.sql.db.mysql.decoder.ResultSetRowDecoder;
import com.github.jasync.sql.db.mysql.message.server.BinaryRowMessage;
import com.github.jasync.sql.db.mysql.message.server.ColumnProcessingFinishedMessage;
import com.github.jasync.sql.db.mysql.message.server.EOFMessage;
import com.github.jasync.sql.db.mysql.message.server.ParamAndColumnProcessingFinishedMessage;
import com.github.jasync.sql.db.mysql.message.server.PreparedStatementPrepareResponse;
import com.github.jasync.sql.db.mysql.message.server.ServerMessage;
import com.github.jasync.sql.db.util.BufferDumper;
import com.github.jasync.sql.db.util.ByteBufExtensionsKt;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00106\u001a\u000207H\u0002J&\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0014J\u0012\u0010@\u001a\u0004\u0018\u00010?2\u0006\u0010A\u001a\u00020<H\u0002J(\u0010B\u001a\u0002072\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010A\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0002J&\u0010E\u001a\u0002072\u0006\u0010F\u001a\u00020G2\u0006\u0010A\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0002J\u0010\u0010H\u001a\u00020\u00142\u0006\u0010A\u001a\u00020<H\u0002J\u0016\u0010I\u001a\u0002072\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020KJ\u0006\u0010M\u001a\u000207J\u0006\u0010N\u001a\u000207R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0016\"\u0004\b-\u0010\u0018R\u000e\u0010.\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010'\"\u0004\b4\u0010)R\u000e\u00105\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/github/jasync/sql/db/mysql/codec/MySQLFrameDecoder;", "Lio/netty/handler/codec/ByteToMessageDecoder;", "charset", "Ljava/nio/charset/Charset;", "connectionId", "", "(Ljava/nio/charset/Charset;Ljava/lang/String;)V", "authenticationSwitchRequestDecoder", "Lcom/github/jasync/sql/db/mysql/decoder/AuthenticationSwitchRequestDecoder;", "getCharset", "()Ljava/nio/charset/Charset;", "columnDecoder", "Lcom/github/jasync/sql/db/mysql/decoder/ColumnDefinitionDecoder;", "errorDecoder", "Lcom/github/jasync/sql/db/mysql/decoder/ErrorDecoder;", "expectedColDefMsgCount", "", "handshakeDecoder", "Lcom/github/jasync/sql/db/mysql/decoder/HandshakeV10Decoder;", "hasDoneHandshake", "", "getHasDoneHandshake", "()Z", "setHasDoneHandshake", "(Z)V", "hasReadColumnsCount", "isInQuery", "setInQuery", "isPreparedStatementExecute", "isPreparedStatementExecuteRows", "isPreparedStatementPrepare", "messagesCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "okDecoder", "Lcom/github/jasync/sql/db/mysql/decoder/OkDecoder;", "preparedStatementPrepareDecoder", "Lcom/github/jasync/sql/db/mysql/decoder/PreparedStatementPrepareResponseDecoder;", "processedColumns", "getProcessedColumns", "()J", "setProcessedColumns", "(J)V", "processedParams", "processingColumns", "getProcessingColumns", "setProcessingColumns", "processingParams", "processingRowData", "rowDecoder", "Lcom/github/jasync/sql/db/mysql/decoder/ResultSetRowDecoder;", "totalColumns", "getTotalColumns", "setTotalColumns", "totalParams", "clear", "", "decode", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "buffer", "Lio/netty/buffer/ByteBuf;", "out", "", "", "decodeQueryResult", "slice", "doDecoding", "decoder", "Lcom/github/jasync/sql/db/mysql/decoder/MessageDecoder;", "handleCommonFlow", "messageType", "", "isValidEOF", "preparedStatementExecuteStarted", "columnsCount", "", "paramsCount", "preparedStatementPrepareStarted", "queryProcessStarted", "jasync-mysql"})
public final class MySQLFrameDecoder
extends ByteToMessageDecoder {
    private final AtomicInteger messagesCount;
    private final HandshakeV10Decoder handshakeDecoder;
    private final ErrorDecoder errorDecoder;
    private final OkDecoder okDecoder;
    private final ColumnDefinitionDecoder columnDecoder;
    private final AuthenticationSwitchRequestDecoder authenticationSwitchRequestDecoder;
    private final ResultSetRowDecoder rowDecoder;
    private final PreparedStatementPrepareResponseDecoder preparedStatementPrepareDecoder;
    private boolean processingColumns;
    private boolean processingParams;
    private boolean isInQuery;
    private boolean processingRowData;
    private boolean isPreparedStatementPrepare;
    private boolean isPreparedStatementExecute;
    private boolean isPreparedStatementExecuteRows;
    private boolean hasDoneHandshake;
    private long totalParams;
    private long processedParams;
    private long totalColumns;
    private long processedColumns;
    private long expectedColDefMsgCount;
    private boolean hasReadColumnsCount;
    @NotNull
    private final Charset charset;
    private final String connectionId;

    public final boolean getProcessingColumns() {
        return this.processingColumns;
    }

    public final void setProcessingColumns(boolean bl) {
        this.processingColumns = bl;
    }

    public final boolean isInQuery() {
        return this.isInQuery;
    }

    public final void setInQuery(boolean bl) {
        this.isInQuery = bl;
    }

    public final boolean getHasDoneHandshake() {
        return this.hasDoneHandshake;
    }

    public final void setHasDoneHandshake(boolean bl) {
        this.hasDoneHandshake = bl;
    }

    public final long getTotalColumns() {
        return this.totalColumns;
    }

    public final void setTotalColumns(long l) {
        this.totalColumns = l;
    }

    public final long getProcessedColumns() {
        return this.processedColumns;
    }

    public final void setProcessedColumns(long l) {
        this.processedColumns = l;
    }

    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf buffer, @NotNull List<Object> out) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(out, (String)"out");
        if (buffer.readableBytes() > 4) {
            buffer.markReaderIndex();
            int size = ByteBufferUtils.read3BytesInt((ByteBuf)buffer);
            buffer.readUnsignedByte();
            if (buffer.readableBytes() < size) {
                buffer.resetReaderIndex();
                return;
            }
            this.messagesCount.incrementAndGet();
            byte messageType = buffer.getByte(buffer.readerIndex());
            if (size < 0) {
                throw (Throwable)new NegativeMessageSizeException(messageType, size);
            }
            ByteBuf slice = buffer.readSlice(size);
            MySQLFrameDecoderKt.access$getLogger$p().trace((Function0)new Function0<Object>(this, messageType, size, slice){
                final /* synthetic */ MySQLFrameDecoder this$0;
                final /* synthetic */ byte $messageType;
                final /* synthetic */ int $size;
                final /* synthetic */ ByteBuf $slice;

                @Nullable
                public final Object invoke() {
                    return "[connectionId:" + MySQLFrameDecoder.access$getConnectionId$p(this.this$0) + "] - Reading message type " + this.$messageType + " - " + "(count=" + MySQLFrameDecoder.access$getMessagesCount$p(this.this$0) + ",hasDoneHandshake=" + this.this$0.getHasDoneHandshake() + ",size=" + this.$size + ",isInQuery=" + this.this$0.isInQuery() + ",processingColumns=" + this.this$0.getProcessingColumns() + ",processingParams=" + MySQLFrameDecoder.access$getProcessingParams$p(this.this$0) + ",processedColumns=" + this.this$0.getProcessedColumns() + ",processedParams=" + MySQLFrameDecoder.access$getProcessedParams$p(this.this$0) + ')' + '\n' + BufferDumper.dumpAsHex((ByteBuf)this.$slice) + '}';
                }
                {
                    this.this$0 = mySQLFrameDecoder;
                    this.$messageType = by;
                    this.$size = n;
                    this.$slice = byteBuf;
                    super(0);
                }
            });
            slice.markReaderIndex();
            slice.readByte();
            if (this.hasDoneHandshake) {
                ByteBuf byteBuf = slice;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"slice");
                this.handleCommonFlow(messageType, byteBuf, out);
            } else {
                MessageDecoder messageDecoder;
                switch (messageType) {
                    case -1: {
                        this.clear();
                        messageDecoder = this.errorDecoder;
                        break;
                    }
                    default: {
                        messageDecoder = this.handshakeDecoder;
                    }
                }
                MessageDecoder decoder = messageDecoder;
                ByteBuf byteBuf = slice;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"slice");
                this.doDecoding(decoder, byteBuf, out);
            }
        }
    }

    private final void handleCommonFlow(byte messageType, ByteBuf slice, List<Object> out) {
        MessageDecoder messageDecoder;
        MySQLFrameDecoderKt.access$getLogger$p().trace((Function0)new Function0<Object>(messageType){
            final /* synthetic */ byte $messageType;

            @Nullable
            public final Object invoke() {
                return "got message type " + this.$messageType;
            }
            {
                this.$messageType = by;
                super(0);
            }
        });
        switch (messageType) {
            case -1: {
                this.clear();
                messageDecoder = this.errorDecoder;
                break;
            }
            case -2: {
                if (this.processingParams && this.totalParams > 0L) {
                    this.processingParams = false;
                    if (this.totalColumns == 0L) {
                        messageDecoder = ParamAndColumnProcessingFinishedDecoder.INSTANCE;
                        break;
                    }
                    messageDecoder = ParamProcessingFinishedDecoder.INSTANCE;
                    break;
                }
                if (this.processingColumns) {
                    this.processingColumns = false;
                    messageDecoder = ColumnProcessingFinishedDecoder.INSTANCE;
                    break;
                }
                if (!this.isValidEOF(slice)) {
                    messageDecoder = this.authenticationSwitchRequestDecoder;
                    break;
                }
                this.clear();
                messageDecoder = EOFMessageDecoder.INSTANCE;
                break;
            }
            case 0: {
                OkDecoder okDecoder;
                if (this.isPreparedStatementPrepare) {
                    if (this.expectedColDefMsgCount <= 0L) {
                        messageDecoder = this.preparedStatementPrepareDecoder;
                        break;
                    }
                    slice.resetReaderIndex();
                    long l = this.expectedColDefMsgCount;
                    this.expectedColDefMsgCount = l + -1L;
                    messageDecoder = this.columnDecoder;
                    break;
                }
                if (this.isPreparedStatementExecuteRows) {
                    okDecoder = null;
                } else if (this.processingRowData) {
                    okDecoder = null;
                } else {
                    this.clear();
                    okDecoder = this.okDecoder;
                }
                messageDecoder = okDecoder;
                break;
            }
            default: {
                if (!this.isInQuery) {
                    throw (Throwable)new ParserNotAvailableException(messageType);
                }
                messageDecoder = null;
            }
        }
        MessageDecoder decoder = messageDecoder;
        this.doDecoding(decoder, slice, out);
    }

    private final boolean isValidEOF(ByteBuf slice) {
        return slice.readableBytes() == 4;
    }

    private final void doDecoding(MessageDecoder decoder, ByteBuf slice, List<Object> out) {
        if (decoder == null) {
            slice.readerIndex(slice.readerIndex() - 1);
            Object result2 = this.decodeQueryResult(slice);
            if (slice.readableBytes() != 0) {
                throw (Throwable)new BufferNotFullyConsumedException(slice);
            }
            if (result2 != null) {
                out.add(result2);
            }
        } else {
            ServerMessage result3 = decoder.decode(slice);
            ServerMessage serverMessage = result3;
            if (serverMessage instanceof PreparedStatementPrepareResponse) {
                this.hasReadColumnsCount = true;
                this.totalColumns = ((PreparedStatementPrepareResponse)result3).getColumnsCount();
                this.totalParams = ((PreparedStatementPrepareResponse)result3).getParamsCount();
                this.expectedColDefMsgCount = this.totalColumns + this.totalParams;
            } else if (serverMessage instanceof ParamAndColumnProcessingFinishedMessage) {
                this.clear();
            } else if (serverMessage instanceof ColumnProcessingFinishedMessage) {
                this.processingRowData = true;
                if (this.isPreparedStatementPrepare) {
                    this.clear();
                } else if (this.isPreparedStatementExecute) {
                    this.isPreparedStatementExecuteRows = true;
                }
            }
            if (slice.readableBytes() != 0) {
                throw (Throwable)new BufferNotFullyConsumedException("Buffer was not fully consumed by decoder, " + slice.readableBytes() + " bytes to read, " + "decoder is " + decoder.getClass().getSimpleName() + " and message is " + result3.getClass().getSimpleName());
            }
            serverMessage = result3;
            if (serverMessage instanceof PreparedStatementPrepareResponse) {
                out.add(result3);
                if (((PreparedStatementPrepareResponse)result3).getColumnsCount() == 0 && ((PreparedStatementPrepareResponse)result3).getParamsCount() == 0) {
                    this.clear();
                    out.add(new ParamAndColumnProcessingFinishedMessage(new EOFMessage(0, 0)));
                }
            } else {
                out.add(result3);
            }
        }
    }

    private final Object decodeQueryResult(ByteBuf slice) {
        ServerMessage serverMessage;
        if (!this.hasReadColumnsCount) {
            this.hasReadColumnsCount = true;
            this.totalColumns = ByteBufExtensionsKt.readBinaryLength((ByteBuf)slice);
            return null;
        }
        if (this.processingParams && this.totalParams != this.processedParams) {
            ++this.processedParams;
            return this.columnDecoder.decode(slice);
        }
        if (this.totalColumns == this.processedColumns) {
            if (this.isPreparedStatementExecute) {
                ByteBuf row2 = slice.readRetainedSlice(slice.readableBytes());
                row2.readByte();
                ByteBuf byteBuf = row2;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"row");
                serverMessage = new BinaryRowMessage(byteBuf);
            } else {
                serverMessage = this.rowDecoder.decode(slice);
            }
        } else {
            ++this.processedColumns;
            serverMessage = this.columnDecoder.decode(slice);
        }
        return serverMessage;
    }

    public final void preparedStatementPrepareStarted() {
        this.queryProcessStarted();
        this.hasReadColumnsCount = true;
        this.processingParams = true;
        this.processingColumns = true;
        this.isPreparedStatementPrepare = true;
    }

    public final void preparedStatementExecuteStarted(int columnsCount, int paramsCount) {
        this.queryProcessStarted();
        this.hasReadColumnsCount = false;
        this.totalColumns = columnsCount;
        this.totalParams = paramsCount;
        this.isPreparedStatementExecute = true;
        this.processingParams = false;
    }

    public final void queryProcessStarted() {
        this.isInQuery = true;
        this.processingColumns = true;
        this.hasReadColumnsCount = false;
    }

    private final void clear() {
        this.isPreparedStatementPrepare = false;
        this.isPreparedStatementExecute = false;
        this.isPreparedStatementExecuteRows = false;
        this.processingRowData = false;
        this.isInQuery = false;
        this.processingColumns = false;
        this.processingParams = false;
        this.totalColumns = 0L;
        this.processedColumns = 0L;
        this.totalParams = 0L;
        this.processedParams = 0L;
        this.hasReadColumnsCount = false;
        this.expectedColDefMsgCount = 0L;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public MySQLFrameDecoder(@NotNull Charset charset, @NotNull String connectionId) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        this.charset = charset;
        this.connectionId = connectionId;
        this.messagesCount = new AtomicInteger();
        this.handshakeDecoder = new HandshakeV10Decoder();
        this.errorDecoder = new ErrorDecoder(this.charset);
        this.okDecoder = new OkDecoder(this.charset);
        this.columnDecoder = new ColumnDefinitionDecoder(this.charset, new DecoderRegistry(this.charset));
        this.authenticationSwitchRequestDecoder = new AuthenticationSwitchRequestDecoder(this.charset);
        this.rowDecoder = new ResultSetRowDecoder();
        this.preparedStatementPrepareDecoder = new PreparedStatementPrepareResponseDecoder();
    }

    public static final /* synthetic */ String access$getConnectionId$p(MySQLFrameDecoder $this) {
        return $this.connectionId;
    }

    public static final /* synthetic */ AtomicInteger access$getMessagesCount$p(MySQLFrameDecoder $this) {
        return $this.messagesCount;
    }

    public static final /* synthetic */ boolean access$getProcessingParams$p(MySQLFrameDecoder $this) {
        return $this.processingParams;
    }

    public static final /* synthetic */ void access$setProcessingParams$p(MySQLFrameDecoder $this, boolean bl) {
        $this.processingParams = bl;
    }

    public static final /* synthetic */ long access$getProcessedParams$p(MySQLFrameDecoder $this) {
        return $this.processedParams;
    }

    public static final /* synthetic */ void access$setProcessedParams$p(MySQLFrameDecoder $this, long l) {
        $this.processedParams = l;
    }
}

