/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.codec;

import com.github.jasync.sql.db.KindedMessage;
import com.github.jasync.sql.db.exceptions.EncoderNotAvailableException;
import com.github.jasync.sql.db.mysql.binary.BinaryRowEncoder;
import com.github.jasync.sql.db.mysql.codec.MySQLOneToOneEncoderKt;
import com.github.jasync.sql.db.mysql.encoder.AuthenticationSwitchResponseEncoder;
import com.github.jasync.sql.db.mysql.encoder.HandshakeResponseEncoder;
import com.github.jasync.sql.db.mysql.encoder.MessageEncoder;
import com.github.jasync.sql.db.mysql.encoder.PreparedStatementCloseEncoder;
import com.github.jasync.sql.db.mysql.encoder.PreparedStatementExecuteEncoder;
import com.github.jasync.sql.db.mysql.encoder.PreparedStatementPrepareEncoder;
import com.github.jasync.sql.db.mysql.encoder.QueryMessageEncoder;
import com.github.jasync.sql.db.mysql.encoder.QuitMessageEncoder;
import com.github.jasync.sql.db.mysql.encoder.SSLRequestEncoder;
import com.github.jasync.sql.db.mysql.message.client.ClientMessage;
import com.github.jasync.sql.db.mysql.util.CharsetMapper;
import com.github.jasync.sql.db.util.BufferDumper;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/github/jasync/sql/db/mysql/codec/MySQLOneToOneEncoder;", "Lio/netty/handler/codec/MessageToMessageEncoder;", "Lcom/github/jasync/sql/db/mysql/message/client/ClientMessage;", "charset", "Ljava/nio/charset/Charset;", "charsetMapper", "Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;", "(Ljava/nio/charset/Charset;Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;)V", "authenticationSwitchEncoder", "Lcom/github/jasync/sql/db/mysql/encoder/AuthenticationSwitchResponseEncoder;", "executeEncoder", "Lcom/github/jasync/sql/db/mysql/encoder/PreparedStatementExecuteEncoder;", "handshakeResponseEncoder", "Lcom/github/jasync/sql/db/mysql/encoder/HandshakeResponseEncoder;", "prepareEncoder", "Lcom/github/jasync/sql/db/mysql/encoder/PreparedStatementPrepareEncoder;", "queryEncoder", "Lcom/github/jasync/sql/db/mysql/encoder/QueryMessageEncoder;", "rowEncoder", "Lcom/github/jasync/sql/db/mysql/binary/BinaryRowEncoder;", "sequence", "", "sslRequestEncoder", "Lcom/github/jasync/sql/db/mysql/encoder/SSLRequestEncoder;", "encode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "message", "out", "", "", "jasync-mysql"})
public final class MySQLOneToOneEncoder
extends MessageToMessageEncoder<ClientMessage> {
    private final SSLRequestEncoder sslRequestEncoder;
    private final HandshakeResponseEncoder handshakeResponseEncoder;
    private final QueryMessageEncoder queryEncoder;
    private final BinaryRowEncoder rowEncoder;
    private final PreparedStatementPrepareEncoder prepareEncoder;
    private final PreparedStatementExecuteEncoder executeEncoder;
    private final AuthenticationSwitchResponseEncoder authenticationSwitchEncoder;
    private int sequence;

    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull ClientMessage message, @NotNull List<Object> out) {
        MessageEncoder messageEncoder;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(out, (String)"out");
        switch (message.getKind()) {
            case 9: {
                messageEncoder = this.handshakeResponseEncoder;
                break;
            }
            case 253: {
                messageEncoder = this.sslRequestEncoder;
                break;
            }
            case 1: {
                this.sequence = 0;
                messageEncoder = QuitMessageEncoder.INSTANCE;
                break;
            }
            case 3: {
                this.sequence = 0;
                messageEncoder = this.queryEncoder;
                break;
            }
            case 23: {
                this.sequence = 0;
                messageEncoder = this.executeEncoder;
                break;
            }
            case 25: {
                this.sequence = 0;
                messageEncoder = PreparedStatementCloseEncoder.INSTANCE;
                break;
            }
            case 22: {
                this.sequence = 0;
                messageEncoder = this.prepareEncoder;
                break;
            }
            case 254: {
                ++this.sequence;
                messageEncoder = this.authenticationSwitchEncoder;
                break;
            }
            default: {
                throw (Throwable)new EncoderNotAvailableException((KindedMessage)message);
            }
        }
        MessageEncoder encoder = messageEncoder;
        ByteBuf result2 = encoder.encode(message);
        ByteBufferUtils.writePacketLength((ByteBuf)result2, (int)this.sequence);
        ++this.sequence;
        if (MySQLOneToOneEncoderKt.access$getLogger$p().isTraceEnabled()) {
            MySQLOneToOneEncoderKt.access$getLogger$p().trace("Writing message " + message.getClass().getSimpleName() + " - \n" + BufferDumper.dumpAsHex((ByteBuf)result2));
        }
        out.add(result2);
    }

    public MySQLOneToOneEncoder(@NotNull Charset charset, @NotNull CharsetMapper charsetMapper) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)charsetMapper, (String)"charsetMapper");
        super(ClientMessage.class);
        this.sslRequestEncoder = new SSLRequestEncoder(charset, charsetMapper);
        this.handshakeResponseEncoder = new HandshakeResponseEncoder(charset, this.sslRequestEncoder);
        this.queryEncoder = new QueryMessageEncoder(charset);
        this.rowEncoder = new BinaryRowEncoder(charset);
        this.prepareEncoder = new PreparedStatementPrepareEncoder(charset);
        this.executeEncoder = new PreparedStatementExecuteEncoder(this.rowEncoder);
        this.authenticationSwitchEncoder = new AuthenticationSwitchResponseEncoder(charset);
        this.sequence = 1;
    }
}

