/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.decoder;

import com.github.jasync.sql.db.mysql.decoder.MessageDecoder;
import com.github.jasync.sql.db.mysql.message.server.AuthenticationSwitchRequest;
import com.github.jasync.sql.db.mysql.message.server.ServerMessage;
import com.github.jasync.sql.db.util.ByteBufExtensionsKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/mysql/decoder/AuthenticationSwitchRequestDecoder;", "Lcom/github/jasync/sql/db/mysql/decoder/MessageDecoder;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "decode", "Lcom/github/jasync/sql/db/mysql/message/server/ServerMessage;", "buffer", "Lio/netty/buffer/ByteBuf;", "jasync-mysql"})
public final class AuthenticationSwitchRequestDecoder
implements MessageDecoder {
    @NotNull
    private final Charset charset;

    @Override
    @NotNull
    public ServerMessage decode(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        String method = ByteBufExtensionsKt.readCString((ByteBuf)buffer, (Charset)this.charset);
        int bytes = buffer.readableBytes();
        byte terminal = (byte)0;
        byte[] salt = bytes > 0 && buffer.getByte(buffer.writerIndex() - 1) == terminal ? ByteBufUtil.getBytes((ByteBuf)buffer, (int)buffer.readerIndex(), (int)(bytes - 1)) : ByteBufUtil.getBytes((ByteBuf)buffer);
        Intrinsics.checkNotNullExpressionValue((Object)salt, (String)"salt");
        return new AuthenticationSwitchRequest(method, salt);
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public AuthenticationSwitchRequestDecoder(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
    }
}

