/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.decoder;

import com.github.jasync.sql.db.mysql.codec.DecoderRegistry;
import com.github.jasync.sql.db.mysql.decoder.MessageDecoder;
import com.github.jasync.sql.db.mysql.message.server.ColumnDefinitionMessage;
import com.github.jasync.sql.db.util.ByteBufExtensionsKt;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/github/jasync/sql/db/mysql/decoder/ColumnDefinitionDecoder;", "Lcom/github/jasync/sql/db/mysql/decoder/MessageDecoder;", "charset", "Ljava/nio/charset/Charset;", "registry", "Lcom/github/jasync/sql/db/mysql/codec/DecoderRegistry;", "(Ljava/nio/charset/Charset;Lcom/github/jasync/sql/db/mysql/codec/DecoderRegistry;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getRegistry", "()Lcom/github/jasync/sql/db/mysql/codec/DecoderRegistry;", "decode", "Lcom/github/jasync/sql/db/mysql/message/server/ColumnDefinitionMessage;", "buffer", "Lio/netty/buffer/ByteBuf;", "jasync-mysql"})
public final class ColumnDefinitionDecoder
implements MessageDecoder {
    @NotNull
    private final Charset charset;
    @NotNull
    private final DecoderRegistry registry;

    @Override
    @NotNull
    public ColumnDefinitionMessage decode(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        String catalog = ByteBufExtensionsKt.readLengthEncodedString((ByteBuf)buffer, (Charset)this.charset);
        String schema = ByteBufExtensionsKt.readLengthEncodedString((ByteBuf)buffer, (Charset)this.charset);
        String table = ByteBufExtensionsKt.readLengthEncodedString((ByteBuf)buffer, (Charset)this.charset);
        String originalTable = ByteBufExtensionsKt.readLengthEncodedString((ByteBuf)buffer, (Charset)this.charset);
        String name = ByteBufExtensionsKt.readLengthEncodedString((ByteBuf)buffer, (Charset)this.charset);
        String originalName = ByteBufExtensionsKt.readLengthEncodedString((ByteBuf)buffer, (Charset)this.charset);
        ByteBufExtensionsKt.readBinaryLength((ByteBuf)buffer);
        int characterSet = buffer.readUnsignedShort();
        long columnLength = buffer.readUnsignedInt();
        short columnType = buffer.readUnsignedByte();
        short flags = buffer.readShort();
        byte decimals = buffer.readByte();
        buffer.readShort();
        return new ColumnDefinitionMessage(catalog, schema, table, originalTable, name, originalName, characterSet, columnLength, columnType, flags, decimals, this.registry.binaryDecoderFor(columnType, characterSet), this.registry.textDecoderFor(columnType, characterSet));
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    @NotNull
    public final DecoderRegistry getRegistry() {
        return this.registry;
    }

    public ColumnDefinitionDecoder(@NotNull Charset charset, @NotNull DecoderRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.charset = charset;
        this.registry = registry;
    }
}

