/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.binary.encoder;

import com.github.jasync.sql.db.mysql.binary.encoder.BinaryEncoder;
import com.github.jasync.sql.db.mysql.column.ColumnTypes;
import com.github.jasync.sql.db.util.DurationUtilsKt;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/jasync/sql/db/mysql/binary/encoder/DurationEncoder;", "Lcom/github/jasync/sql/db/mysql/binary/encoder/BinaryEncoder;", "()V", "Zero", "Ljava/time/Duration;", "encode", "", "value", "", "buffer", "Lio/netty/buffer/ByteBuf;", "encodesTo", "", "jasync-mysql"})
public final class DurationEncoder
implements BinaryEncoder {
    @NotNull
    public static final DurationEncoder INSTANCE = new DurationEncoder();
    @NotNull
    private static final Duration Zero = DurationUtilsKt.getSeconds((int)0);

    private DurationEncoder() {
    }

    @Override
    public void encode(@NotNull Object value, @NotNull ByteBuf buffer) {
        boolean hasMicros;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Duration duration = (Duration)value;
        long days = duration.toDays();
        Duration hoursDuration = duration.minus(DurationUtilsKt.getDays((long)days));
        long hours = hoursDuration.toHours();
        Duration minutesDuration = hoursDuration.minus(DurationUtilsKt.getHours((long)hours));
        long minutes = minutesDuration.toMinutes();
        Duration secondsDuration = minutesDuration.minus(DurationUtilsKt.getMinutes((long)minutes));
        long seconds = secondsDuration.getSeconds();
        Duration microsDuration = secondsDuration.minus(DurationUtilsKt.getSeconds((long)seconds));
        Intrinsics.checkNotNullExpressionValue((Object)microsDuration, (String)"microsDuration");
        long micros = DurationUtilsKt.getMicros((Duration)microsDuration);
        boolean bl = hasMicros = micros != 0L;
        if (hasMicros) {
            buffer.writeByte(12);
        } else {
            buffer.writeByte(8);
        }
        if (duration.compareTo(Zero) > 0) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(1);
        }
        buffer.writeInt((int)days);
        buffer.writeByte((int)hours);
        buffer.writeByte((int)minutes);
        buffer.writeByte((int)seconds);
        if (hasMicros) {
            buffer.writeLong(micros);
        }
    }

    @Override
    public int encodesTo() {
        return ColumnTypes.INSTANCE.getFIELD_TYPE_TIME();
    }
}

