/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder.auth;

import com.github.jasync.sql.db.mysql.encoder.auth.AuthenticationMethod;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/auth/MySQLNativePasswordAuthentication;", "Lcom/github/jasync/sql/db/mysql/encoder/auth/AuthenticationMethod;", "()V", "EmptyArray", "", "getEmptyArray", "()[B", "generateAuthentication", "charset", "Ljava/nio/charset/Charset;", "password", "", "seed", "scramble411", "jasync-mysql"})
public final class MySQLNativePasswordAuthentication
implements AuthenticationMethod {
    @NotNull
    public static final MySQLNativePasswordAuthentication INSTANCE = new MySQLNativePasswordAuthentication();
    @NotNull
    private static final byte[] EmptyArray = new byte[0];

    private MySQLNativePasswordAuthentication() {
    }

    @NotNull
    public final byte[] getEmptyArray() {
        return EmptyArray;
    }

    @Override
    @NotNull
    public byte[] generateAuthentication(@NotNull Charset charset, @Nullable String password, @NotNull byte[] seed) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        return password != null ? this.scramble411(charset, password, seed) : EmptyArray;
    }

    private final byte[] scramble411(Charset charset, String password, byte[] seed) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] byArray = password.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] initialDigest = messageDigest.digest(byArray);
        messageDigest.reset();
        byte[] finalDigest = messageDigest.digest(initialDigest);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(finalDigest);
        byte[] result2 = messageDigest.digest();
        int counter = 0;
        while (true) {
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
            if (counter >= CollectionsUtilsKt.getLength((byte[])result2)) break;
            result2[counter] = (byte)(result2[counter] ^ initialDigest[counter]);
            ++counter;
        }
        return result2;
    }
}

