/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder;

import com.github.jasync.sql.db.exceptions.UnsupportedAuthenticationMethodException;
import com.github.jasync.sql.db.mysql.encoder.HandshakeResponseEncoder;
import com.github.jasync.sql.db.mysql.encoder.MessageEncoder;
import com.github.jasync.sql.db.mysql.encoder.SSLRequestEncoder;
import com.github.jasync.sql.db.mysql.encoder.auth.AuthenticationMethod;
import com.github.jasync.sql.db.mysql.message.client.ClientMessage;
import com.github.jasync.sql.db.mysql.message.client.HandshakeResponseMessage;
import com.github.jasync.sql.db.util.ByteBufExtensionsKt;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/HandshakeResponseEncoder;", "Lcom/github/jasync/sql/db/mysql/encoder/MessageEncoder;", "charset", "Ljava/nio/charset/Charset;", "headerEncoder", "Lcom/github/jasync/sql/db/mysql/encoder/SSLRequestEncoder;", "(Ljava/nio/charset/Charset;Lcom/github/jasync/sql/db/mysql/encoder/SSLRequestEncoder;)V", "authenticationMethods", "", "", "Lcom/github/jasync/sql/db/mysql/encoder/auth/AuthenticationMethod;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/mysql/message/client/ClientMessage;", "Companion", "jasync-mysql"})
public final class HandshakeResponseEncoder
implements MessageEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Charset charset;
    @NotNull
    private final SSLRequestEncoder headerEncoder;
    @NotNull
    private final Map<String, AuthenticationMethod> authenticationMethods;
    @NotNull
    private static final String APP_NAME_KEY = "_client_name";

    public HandshakeResponseEncoder(@NotNull Charset charset, @NotNull SSLRequestEncoder headerEncoder) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)headerEncoder, (String)"headerEncoder");
        this.charset = charset;
        this.headerEncoder = headerEncoder;
        this.authenticationMethods = AuthenticationMethod.Companion.getAvailables();
    }

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        HandshakeResponseMessage m = (HandshakeResponseMessage)message;
        ByteBuf buffer = this.headerEncoder.encode(m.getHeader());
        ByteBufferUtils.writeCString((String)m.getUsername(), (ByteBuf)buffer, (Charset)this.charset);
        if (m.getPassword() != null) {
            String method = m.getAuthenticationMethod();
            AuthenticationMethod authenticationMethod = this.authenticationMethods.get(method);
            if (authenticationMethod == null) {
                boolean bl = false;
                throw new UnsupportedAuthenticationMethodException(method);
            }
            AuthenticationMethod authenticator = authenticationMethod;
            byte[] bytes = authenticator.generateAuthentication(this.charset, m.getPassword(), m.getSeed());
            buffer.writeByte(CollectionsUtilsKt.getLength((byte[])bytes));
            buffer.writeBytes(bytes);
        } else {
            buffer.writeByte(0);
        }
        if (m.getDatabase() != null) {
            ByteBufferUtils.writeCString((String)m.getDatabase(), (ByteBuf)buffer, (Charset)this.charset);
        }
        ByteBufferUtils.writeCString((String)m.getAuthenticationMethod(), (ByteBuf)buffer, (Charset)this.charset);
        if (m.getAppName() != null) {
            Function1 byteWidthEvaluator2 = encode.byteWidthEvaluator.1.INSTANCE;
            byte[] byArray = APP_NAME_KEY.getBytes(this.charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] key = byArray;
            byte[] byArray2 = m.getAppName().getBytes(this.charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byte[] value = byArray2;
            int totalLength = CollectionsUtilsKt.getLength((byte[])key) + ((Number)byteWidthEvaluator2.invoke((Object)CollectionsUtilsKt.getLength((byte[])key))).intValue() + CollectionsUtilsKt.getLength((byte[])value) + ((Number)byteWidthEvaluator2.invoke((Object)CollectionsUtilsKt.getLength((byte[])value))).intValue();
            ByteBufExtensionsKt.writeLength((ByteBuf)buffer, (long)totalLength);
            ByteBufExtensionsKt.writeLengthEncodedString((ByteBuf)buffer, (String)APP_NAME_KEY, (Charset)this.charset);
            ByteBufExtensionsKt.writeLengthEncodedString((ByteBuf)buffer, (String)m.getAppName(), (Charset)this.charset);
        }
        return buffer;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/HandshakeResponseEncoder$Companion;", "", "()V", "APP_NAME_KEY", "", "jasync-mysql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

