/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.encoders;

import com.github.jasync.sql.db.postgresql.encoders.CredentialEncoder$WhenMappings;
import com.github.jasync.sql.db.postgresql.encoders.Encoder;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.CredentialMessage;
import com.github.jasync.sql.db.postgresql.util.PasswordHelper;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/postgresql/encoders/CredentialEncoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/Encoder;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "jasync-postgresql"})
public final class CredentialEncoder
implements Encoder {
    @NotNull
    private final Charset charset;

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CredentialMessage credentialMessage = (CredentialMessage)message;
        switch (CredentialEncoder$WhenMappings.$EnumSwitchMapping$0[credentialMessage.getAuthenticationType().ordinal()]) {
            case 1: {
                String string = credentialMessage.getPassword();
                Charset charset = this.charset;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string2.getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                break;
            }
            case 2: {
                byArray = PasswordHelper.encode(credentialMessage.getUsername(), credentialMessage.getPassword(), credentialMessage.getSalt(), this.charset);
                break;
            }
            default: {
                String reason$iv = "no handle " + (Object)((Object)credentialMessage.getAuthenticationType());
                boolean $i$f$XXX = false;
                throw (Throwable)new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
            }
        }
        byte[] password = byArray;
        ByteBuf buffer = Unpooled.buffer((int)(5 + password.length + 1));
        buffer.writeByte(112);
        buffer.writeInt(0);
        buffer.writeBytes(password);
        buffer.writeByte(0);
        ByteBufferUtils.writeLength((ByteBuf)buffer);
        ByteBuf byteBuf = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
        return byteBuf;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public CredentialEncoder(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        this.charset = charset;
    }
}

