/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.encoders;

import com.github.jasync.sql.db.column.ColumnEncoderRegistry;
import com.github.jasync.sql.db.postgresql.encoders.Encoder;
import com.github.jasync.sql.db.postgresql.encoders.PreparedStatementEncoderHelper;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/github/jasync/sql/db/postgresql/encoders/ExecutePreparedStatementEncoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/Encoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/PreparedStatementEncoderHelper;", "charset", "Ljava/nio/charset/Charset;", "encoder", "Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "(Ljava/nio/charset/Charset;Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getEncoder", "()Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "jasync-postgresql"})
public final class ExecutePreparedStatementEncoder
implements Encoder,
PreparedStatementEncoderHelper {
    @NotNull
    private final Charset charset;
    @NotNull
    private final ColumnEncoderRegistry encoder;

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        PreparedStatementExecuteMessage m = (PreparedStatementExecuteMessage)message;
        String string = String.valueOf(m.getStatementId());
        Charset charset = this.charset;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] statementIdBytes = byArray;
        return PreparedStatementEncoderHelper.DefaultImpls.writeExecutePortal$default(this, statementIdBytes, m.getQuery(), m.getValues(), this.encoder, this.charset, false, 32, null);
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    @NotNull
    public final ColumnEncoderRegistry getEncoder() {
        return this.encoder;
    }

    public ExecutePreparedStatementEncoder(@NotNull Charset charset, @NotNull ColumnEncoderRegistry encoder) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
        this.charset = charset;
        this.encoder = encoder;
    }

    @Override
    @NotNull
    public ByteBuf writeExecutePortal(@NotNull byte[] statementIdBytes, @NotNull String query, @NotNull List<? extends Object> values, @NotNull ColumnEncoderRegistry encoder, @NotNull Charset charset, boolean writeDescribe) {
        Intrinsics.checkParameterIsNotNull((Object)statementIdBytes, (String)"statementIdBytes");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return PreparedStatementEncoderHelper.DefaultImpls.writeExecutePortal(this, statementIdBytes, query, values, encoder, charset, writeDescribe);
    }

    @Override
    @NotNull
    public ByteBuf closeAndSyncBuffer(@NotNull byte[] statementIdBytes, char closeType) {
        Intrinsics.checkParameterIsNotNull((Object)statementIdBytes, (String)"statementIdBytes");
        return PreparedStatementEncoderHelper.DefaultImpls.closeAndSyncBuffer(this, statementIdBytes, closeType);
    }
}

