/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.encoders;

import com.github.jasync.sql.db.postgresql.encoders.Encoder;
import com.github.jasync.sql.db.postgresql.encoders.QueryMessageEncoderKt;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.QueryMessage;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/postgresql/encoders/QueryMessageEncoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/Encoder;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "jasync-postgresql"})
public final class QueryMessageEncoder
implements Encoder {
    @NotNull
    private final Charset charset;

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        QueryMessage m = (QueryMessage)message;
        QueryMessageEncoderKt.access$getLogger$p().debug("Executing direct query ({})", (Object)m.getQuery());
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeByte(81);
        buffer.writeInt(0);
        ByteBufferUtils.writeCString((String)m.getQuery(), (ByteBuf)buffer, (Charset)this.charset);
        ByteBufferUtils.writeLength((ByteBuf)buffer);
        ByteBuf byteBuf = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
        return byteBuf;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public QueryMessageEncoder(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        this.charset = charset;
    }
}

