/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.util.HexCodec;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010(\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/ByteArrayEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "HexStart", "", "HexStartChars", "", "decode", "", "value", "encode", "", "getCharOrDie", "", "ci", "", "jasync-postgresql"})
public final class ByteArrayEncoderDecoder
implements ColumnEncoderDecoder {
    private static final String HexStart = "\\x";
    private static final char[] HexStartChars;
    public static final ByteArrayEncoderDecoder INSTANCE;

    @NotNull
    public byte[] decode(@NotNull String value) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (StringsKt.startsWith$default((String)value, (String)HexStart, (boolean)false, (int)2, null)) {
            byte[] byArray2 = HexCodec.decode((CharSequence)value, (int)2);
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"HexCodec.decode(value, 2)");
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(value.length());
            CharIterator ci = StringsKt.iterator((CharSequence)value);
            block6: while (ci.hasNext()) {
                char nextCi1 = ci.nextChar();
                switch (nextCi1) {
                    case '\\': {
                        char nextCi2 = this.getCharOrDie((Iterator)ci);
                        switch (nextCi2) {
                            case '\\': {
                                buffer.put((byte)92);
                                continue block6;
                            }
                        }
                        char secondDigit = this.getCharOrDie((Iterator)ci);
                        char thirdDigit = this.getCharOrDie((Iterator)ci);
                        buffer.put((byte)Integer.decode("" + '0' + nextCi2 + secondDigit + thirdDigit).intValue());
                        continue block6;
                    }
                }
                buffer.put((byte)nextCi1);
            }
            buffer.flip();
            byte[] finalArray = new byte[buffer.remaining()];
            buffer.get(finalArray);
            byArray = finalArray;
        }
        return byArray;
    }

    private final char getCharOrDie(Iterator<Character> ci) {
        if (!ci.hasNext()) {
            throw (Throwable)new IllegalArgumentException("Expected escape sequence character, found nothing");
        }
        return ci.next().charValue();
    }

    @NotNull
    public String encode(@NotNull Object value) {
        byte[] arr;
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (value instanceof byte[]) {
            byArray = (byte[])value;
        } else if (value instanceof ByteBuffer && ((ByteBuffer)value).hasArray()) {
            byte[] byArray2 = ((ByteBuffer)value).array();
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"value.array()");
        } else if (value instanceof ByteBuffer) {
            arr = new byte[((ByteBuffer)value).remaining()];
            ((ByteBuffer)value).get(arr);
            byArray = arr;
        } else if (value instanceof ByteBuf && ((ByteBuf)value).hasArray()) {
            byte[] byArray3 = ((ByteBuf)value).array();
            byArray = byArray3;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"value.array()");
        } else if (value instanceof ByteBuf) {
            arr = new byte[((ByteBuf)value).readableBytes()];
            ((ByteBuf)value).getBytes(0, arr);
            byArray = arr;
        } else {
            String reason$iv = value + " - " + value.getClass();
            boolean $i$f$XXX = false;
            throw (Throwable)new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
        }
        byte[] array = byArray;
        String string = HexCodec.encode((byte[])array, (char[])HexStartChars);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HexCodec.encode(array, HexStartChars)");
        return string;
    }

    private ByteArrayEncoderDecoder() {
    }

    static {
        ByteArrayEncoderDecoder byteArrayEncoderDecoder;
        INSTANCE = byteArrayEncoderDecoder = new ByteArrayEncoderDecoder();
        String string = HexStart;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        HexStartChars = cArray;
    }

    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return ColumnEncoderDecoder.DefaultImpls.decode((ColumnEncoderDecoder)this, (ColumnData)kind, (ByteBuf)value, (Charset)charset);
    }

    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding((ColumnEncoderDecoder)this);
    }
}

