/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.encoders;

import com.github.jasync.sql.db.column.ColumnEncoderRegistry;
import com.github.jasync.sql.db.postgresql.encoders.CloseStatementEncoderKt;
import com.github.jasync.sql.db.postgresql.encoders.Encoder;
import com.github.jasync.sql.db.postgresql.encoders.PreparedStatementEncoderHelper;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementCloseMessage;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/github/jasync/sql/db/postgresql/encoders/CloseStatementEncoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/Encoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/PreparedStatementEncoderHelper;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "jasync-postgresql"})
public final class CloseStatementEncoder
implements Encoder,
PreparedStatementEncoderHelper {
    @NotNull
    private final Charset charset;

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PreparedStatementCloseMessage m = (PreparedStatementCloseMessage)message;
        if (CloseStatementEncoderKt.access$getLogger$p().isDebugEnabled()) {
            CloseStatementEncoderKt.access$getLogger$p().debug("Closing statement ({})", (Object)m);
        }
        String string = m.getStatementId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.statementId.toString()");
        String string2 = string;
        Charset charset = this.charset;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return this.closeAndSyncBuffer(byArray, 'S');
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public CloseStatementEncoder(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
    }

    @Override
    @NotNull
    public ByteBuf writeExecutePortal(@NotNull byte[] statementIdBytes, @NotNull String query, @NotNull List<? extends Object> values, @NotNull ColumnEncoderRegistry encoder, @NotNull Charset charset, boolean writeDescribe) {
        Intrinsics.checkNotNullParameter((Object)statementIdBytes, (String)"statementIdBytes");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return PreparedStatementEncoderHelper.DefaultImpls.writeExecutePortal(this, statementIdBytes, query, values, encoder, charset, writeDescribe);
    }

    @Override
    @NotNull
    public ByteBuf closeAndSyncBuffer(@NotNull byte[] statementIdBytes, char closeType) {
        Intrinsics.checkNotNullParameter((Object)statementIdBytes, (String)"statementIdBytes");
        return PreparedStatementEncoderHelper.DefaultImpls.closeAndSyncBuffer(this, statementIdBytes, closeType);
    }
}

