/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.parsers;

import com.github.jasync.sql.db.postgresql.messages.backend.ServerMessage;
import com.github.jasync.sql.db.postgresql.parsers.MessageParser;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH&J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/github/jasync/sql/db/postgresql/parsers/InformationParser;", "Lcom/github/jasync/sql/db/postgresql/parsers/MessageParser;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "createMessage", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ServerMessage;", "fields", "", "", "", "parseMessage", "buffer", "Lio/netty/buffer/ByteBuf;", "jasync-postgresql"})
public abstract class InformationParser
implements MessageParser {
    @NotNull
    private final Charset charset;

    @Override
    @NotNull
    public ServerMessage parseMessage(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        boolean bl = false;
        Map fields = new LinkedHashMap();
        while (buffer.isReadable()) {
            byte kind = buffer.readByte();
            if (kind == 0) continue;
            Character c = Character.valueOf((char)kind);
            String string = ByteBufferUtils.readCString((ByteBuf)buffer, (Charset)this.charset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ByteBufferUtils.readCString(buffer, charset)");
            fields.put(c, string);
        }
        return this.createMessage(MapsKt.toMap((Map)fields));
    }

    @NotNull
    public abstract ServerMessage createMessage(@NotNull Map<Character, String> var1);

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public InformationParser(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
    }
}

