/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.exceptions.DateEncoderNotAvailableException;
import com.github.jasync.sql.db.general.ColumnData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Period;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.threeten.extra.PeriodDuration;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\n \u0005*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\n \u0005*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\n \u0005*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLIntervalEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "hmsParser", "Lorg/joda/time/format/PeriodFormatter;", "kotlin.jvm.PlatformType", "postgresParser", "postgres_verboseParser", "sqlDTParser", "sqlParser", "decode", "Lorg/threeten/extra/PeriodDuration;", "value", "", "encode", "", "postgresHMSBuilder", "Lorg/joda/time/format/PeriodFormatterBuilder;", "builder", "postgresYMDBuilder", "sqlDTBuilder", "jasync-postgresql"})
public final class PostgreSQLIntervalEncoderDecoder
implements ColumnEncoderDecoder {
    private static final PeriodFormatter postgres_verboseParser;
    private static final PeriodFormatter hmsParser;
    private static final PeriodFormatter postgresParser;
    private static final PeriodFormatter sqlDTParser;
    private static final PeriodFormatter sqlParser;
    @NotNull
    public static final PostgreSQLIntervalEncoderDecoder INSTANCE;

    @NotNull
    public String encode(@NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof PeriodDuration) {
            string = value.toString();
        } else if (object instanceof Period) {
            String string2 = PeriodDuration.of((Period)((Period)value)).toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PeriodDuration.of(value).toString()");
        } else if (object instanceof Duration) {
            String string3 = PeriodDuration.of((Duration)((Duration)value)).toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PeriodDuration.of(value).toString()");
        } else {
            throw (Throwable)new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    private final PeriodFormatterBuilder postgresYMDBuilder(PeriodFormatterBuilder builder) {
        return builder.appendYears().appendSuffix(" year", " years").appendSeparator(" ").appendMonths().appendSuffix(" mon", " mons").appendSeparator(" ").appendDays().appendSuffix(" day", " days").appendSeparator(" ");
    }

    private final PeriodFormatterBuilder postgresHMSBuilder(PeriodFormatterBuilder builder) {
        return builder.rejectSignedValues(true).appendHours().appendSuffix(":").appendMinutes().appendSuffix(":").appendSecondsWithOptionalMillis();
    }

    private final PeriodFormatterBuilder sqlDTBuilder(PeriodFormatterBuilder builder) {
        PeriodFormatterBuilder periodFormatterBuilder = builder.appendDays().appendSeparator(" ");
        Intrinsics.checkNotNullExpressionValue((Object)periodFormatterBuilder, (String)"builder\n                \u2026ys().appendSeparator(\" \")");
        return this.postgresHMSBuilder(periodFormatterBuilder);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public PeriodDuration decode(@NotNull String value) {
        block8: {
            block10: {
                block12: {
                    block14: {
                        block13: {
                            block6: {
                                block11: {
                                    block9: {
                                        block7: {
                                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                            var2_2 = value;
                                            var3_3 = false;
                                            if (!(var2_2.length() == 0)) break block7;
                                            v0 = PeriodDuration.ZERO;
                                            v1 = v0;
                                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"PeriodDuration.ZERO");
                                            break block8;
                                        }
                                        if (!StringsKt.startsWith$default((CharSequence)value, (char)'P', (boolean)false, (int)2, null)) break block9;
                                        v2 = PeriodDuration.parse((CharSequence)value);
                                        break block10;
                                    }
                                    if (!StringsKt.startsWith$default((String)value, (String)"@ ", (boolean)false, (int)2, null)) break block11;
                                    v3 = PostgreSQLIntervalEncoderDecoder.postgres_verboseParser;
                                    break block12;
                                }
                                $this$indexOfFirst$iv = value;
                                $i$f$indexOfFirst = false;
                                var6_9 = 0;
                                var7_10 = $this$indexOfFirst$iv.length();
                                while (var6_9 < var7_10) {
                                    it = $this$indexOfFirst$iv.charAt((int)index$iv);
                                    $i$a$-indexOfFirst-PostgreSQLIntervalEncoderDecoder$decode$format$i$1 = false;
                                    var10_13 = it;
                                    var11_14 = false;
                                    if (Character.isDigit(var10_13) == false) {
                                        v4 = index$iv;
                                        break block6;
                                    }
                                    ++index$iv;
                                }
                                v4 = '\uffffffff';
                            }
                            var4_6 = v4;
                            var5_8 = 0;
                            var6_9 = 0;
                            it = var4_6;
                            $i$a$-let-PostgreSQLIntervalEncoderDecoder$decode$format$i$2 = false;
                            v5 = i = StringsKt.contains$default((CharSequence)"-+", (char)value.charAt(0), (boolean)false, (int)2, null) != false ? 1 : 0;
                            if (i >= 0 && !StringsKt.contains$default((CharSequence)":.", (char)value.charAt(i), (boolean)false, (int)2, null)) break block13;
                            v3 = PostgreSQLIntervalEncoderDecoder.hmsParser;
                            break block12;
                        }
                        if (value.charAt(i) != '-') break block14;
                        v3 = PostgreSQLIntervalEncoderDecoder.sqlParser;
                        break block12;
                    }
                    if (value.charAt(i) != ' ' || i + 1 >= value.length()) ** GOTO lbl-1000
                    var4_6 = value.charAt(i + 1);
                    var5_8 = 0;
                    if (Character.isDigit(var4_6)) {
                        v3 = PostgreSQLIntervalEncoderDecoder.sqlDTParser;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = format = PostgreSQLIntervalEncoderDecoder.postgresParser;
                    }
                }
                if (Intrinsics.areEqual((Object)format, (Object)PostgreSQLIntervalEncoderDecoder.hmsParser) && StringsKt.startsWith$default((CharSequence)value, (char)'-', (boolean)false, (int)2, null)) {
                    var4_7 = value;
                    var5_8 = 1;
                    var6_9 = 0;
                    v6 = var4_7.substring(var5_8);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"(this as java.lang.String).substring(startIndex)");
                    v7 = format.parsePeriod(v6).negated();
                } else {
                    v7 = StringsKt.endsWith$default((String)value, (String)" ago", (boolean)false, (int)2, null) != false ? format.parsePeriod(StringsKt.removeSuffix((String)value, (CharSequence)" ago")).negated() : format.parsePeriod(value);
                }
                v8 = jodaPeriod = v7;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"jodaPeriod");
                v2 = PeriodDuration.of((Period)Period.of(v8.getYears(), jodaPeriod.getMonths(), jodaPeriod.getDays()), (Duration)Duration.ofHours(jodaPeriod.getHours()).plusMinutes(jodaPeriod.getMinutes()).plusSeconds(jodaPeriod.getSeconds()).plusMillis(jodaPeriod.getMillis()));
            }
            v1 = v2;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"if (value.startsWith('P'\u2026)\n            )\n        }");
        }
        return v1;
    }

    private PostgreSQLIntervalEncoderDecoder() {
    }

    static {
        PostgreSQLIntervalEncoderDecoder postgreSQLIntervalEncoderDecoder;
        INSTANCE = postgreSQLIntervalEncoderDecoder = new PostgreSQLIntervalEncoderDecoder();
        PeriodFormatterBuilder periodFormatterBuilder = new PeriodFormatterBuilder().appendLiteral("@ ");
        Intrinsics.checkNotNullExpressionValue((Object)periodFormatterBuilder, (String)"PeriodFormatterBuilder().appendLiteral(\"@ \")");
        postgres_verboseParser = postgreSQLIntervalEncoderDecoder.postgresYMDBuilder(periodFormatterBuilder).appendHours().appendSuffix(" hour", " hours").appendSeparator(" ").appendMinutes().appendSuffix(" min", " mins").appendSeparator(" ").appendSecondsWithOptionalMillis().appendSuffix(" sec", " secs").toFormatter();
        hmsParser = postgreSQLIntervalEncoderDecoder.postgresHMSBuilder(new PeriodFormatterBuilder()).toFormatter();
        PeriodFormatterBuilder periodFormatterBuilder2 = postgreSQLIntervalEncoderDecoder.postgresYMDBuilder(new PeriodFormatterBuilder());
        Intrinsics.checkNotNullExpressionValue((Object)periodFormatterBuilder2, (String)"postgresYMDBuilder(PeriodFormatterBuilder())");
        postgresParser = postgreSQLIntervalEncoderDecoder.postgresHMSBuilder(periodFormatterBuilder2).toFormatter();
        sqlDTParser = postgreSQLIntervalEncoderDecoder.sqlDTBuilder(new PeriodFormatterBuilder()).toFormatter();
        PeriodFormatterBuilder periodFormatterBuilder3 = new PeriodFormatterBuilder().printZeroAlways().rejectSignedValues(true).appendYears().appendSeparator("-").appendMonths().rejectSignedValues(false).printZeroNever().appendSeparator(" ");
        Intrinsics.checkNotNullExpressionValue((Object)periodFormatterBuilder3, (String)"PeriodFormatterBuilder()\u2026    .appendSeparator(\" \")");
        sqlParser = postgreSQLIntervalEncoderDecoder.sqlDTBuilder(periodFormatterBuilder3).toFormatter();
    }

    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return ColumnEncoderDecoder.DefaultImpls.decode((ColumnEncoderDecoder)this, (ColumnData)kind, (ByteBuf)value, (Charset)charset);
    }

    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding((ColumnEncoderDecoder)this);
    }
}

