/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.exceptions.DateEncoderNotAvailableException;
import com.github.jasync.sql.db.general.ColumnData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Period;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.threeten.extra.PeriodDuration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\n \u0005*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\n \u0005*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\n \u0005*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLIntervalEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "hmsParser", "Lorg/joda/time/format/PeriodFormatter;", "kotlin.jvm.PlatformType", "postgresParser", "postgres_verboseParser", "sqlDTParser", "sqlParser", "decode", "Lorg/threeten/extra/PeriodDuration;", "value", "", "encode", "", "postgresHMSBuilder", "Lorg/joda/time/format/PeriodFormatterBuilder;", "builder", "postgresYMDBuilder", "sqlDTBuilder", "jasync-postgresql"})
@SourceDebugExtension(value={"SMAP\nPostgreSQLIntervalEncoderDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostgreSQLIntervalEncoderDecoder.kt\ncom/github/jasync/sql/db/postgresql/column/PostgreSQLIntervalEncoderDecoder\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n151#2,6:118\n1#3:124\n*S KotlinDebug\n*F\n+ 1 PostgreSQLIntervalEncoderDecoder.kt\ncom/github/jasync/sql/db/postgresql/column/PostgreSQLIntervalEncoderDecoder\n*L\n86#1:118,6\n*E\n"})
public final class PostgreSQLIntervalEncoderDecoder
implements ColumnEncoderDecoder {
    @NotNull
    public static final PostgreSQLIntervalEncoderDecoder INSTANCE = new PostgreSQLIntervalEncoderDecoder();
    private static final PeriodFormatter postgres_verboseParser;
    private static final PeriodFormatter hmsParser;
    private static final PeriodFormatter postgresParser;
    private static final PeriodFormatter sqlDTParser;
    private static final PeriodFormatter sqlParser;

    private PostgreSQLIntervalEncoderDecoder() {
    }

    @NotNull
    public String encode(@NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof PeriodDuration) {
            string = value.toString();
        } else if (object instanceof Period) {
            String string2 = PeriodDuration.of((Period)((Period)value)).toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"of(value).toString()");
        } else if (object instanceof Duration) {
            String string3 = PeriodDuration.of((Duration)((Duration)value)).toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"of(value).toString()");
        } else {
            throw new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    private final PeriodFormatterBuilder postgresYMDBuilder(PeriodFormatterBuilder builder) {
        return builder.appendYears().appendSuffix(" year", " years").appendSeparator(" ").appendMonths().appendSuffix(" mon", " mons").appendSeparator(" ").appendDays().appendSuffix(" day", " days").appendSeparator(" ");
    }

    private final PeriodFormatterBuilder postgresHMSBuilder(PeriodFormatterBuilder builder) {
        return builder.rejectSignedValues(true).appendHours().appendSuffix(":").appendMinutes().appendSuffix(":").appendSecondsWithOptionalMillis();
    }

    private final PeriodFormatterBuilder sqlDTBuilder(PeriodFormatterBuilder builder) {
        PeriodFormatterBuilder periodFormatterBuilder = builder.appendDays().appendSeparator(" ");
        Intrinsics.checkNotNullExpressionValue((Object)periodFormatterBuilder, (String)"builder\n                \u2026ys().appendSeparator(\" \")");
        return this.postgresHMSBuilder(periodFormatterBuilder);
    }

    @NotNull
    public PeriodDuration decode(@NotNull String value) {
        PeriodDuration periodDuration;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            PeriodDuration periodDuration2 = PeriodDuration.ZERO;
            periodDuration = periodDuration2;
            Intrinsics.checkNotNullExpressionValue((Object)periodDuration2, (String)"{ /* huh? */\n           \u2026odDuration.ZERO\n        }");
        } else if (StringsKt.startsWith$default((CharSequence)value, (char)'P', (boolean)false, (int)2, null)) {
            PeriodDuration periodDuration3 = PeriodDuration.parse((CharSequence)value);
            periodDuration = periodDuration3;
            Intrinsics.checkNotNullExpressionValue((Object)periodDuration3, (String)"{\n            PeriodDura\u2026on.parse(value)\n        }");
        } else {
            org.joda.time.Period period;
            PeriodFormatter format;
            PeriodFormatter periodFormatter;
            if (StringsKt.startsWith$default((String)value, (String)"@ ", (boolean)false, (int)2, null)) {
                periodFormatter = postgres_verboseParser;
            } else {
                int n;
                block9: {
                    CharSequence $this$indexOfFirst$iv = value;
                    boolean $i$f$indexOfFirst = false;
                    int n2 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n2; ++index$iv) {
                        char it = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl = false;
                        boolean bl2 = !Character.isDigit(it);
                        if (!bl2) continue;
                        n = index$iv;
                        break block9;
                    }
                    n = -1;
                }
                int it = n;
                boolean bl = false;
                int i2 = StringsKt.contains$default((CharSequence)"-+", (char)value.charAt(0), (boolean)false, (int)2, null) ? 1 : 0;
                periodFormatter = i2 < 0 || StringsKt.contains$default((CharSequence)":.", (char)value.charAt(i2), (boolean)false, (int)2, null) ? hmsParser : (value.charAt(i2) == '-' ? sqlParser : (format = value.charAt(i2) == ' ' && i2 + 1 < value.length() && Character.isDigit(value.charAt(i2 + 1)) ? sqlDTParser : postgresParser));
            }
            if (Intrinsics.areEqual((Object)format, (Object)hmsParser) && StringsKt.startsWith$default((CharSequence)value, (char)'-', (boolean)false, (int)2, null)) {
                String string = value.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                period = format.parsePeriod(string).negated();
            } else {
                period = StringsKt.endsWith$default((String)value, (String)" ago", (boolean)false, (int)2, null) ? format.parsePeriod(StringsKt.removeSuffix((String)value, (CharSequence)" ago")).negated() : format.parsePeriod(value);
            }
            org.joda.time.Period jodaPeriod = period;
            PeriodDuration periodDuration4 = PeriodDuration.of((Period)Period.of(jodaPeriod.getYears(), jodaPeriod.getMonths(), jodaPeriod.getDays()), (Duration)Duration.ofHours(jodaPeriod.getHours()).plusMinutes(jodaPeriod.getMinutes()).plusSeconds(jodaPeriod.getSeconds()).plusMillis(jodaPeriod.getMillis()));
            periodDuration = periodDuration4;
            Intrinsics.checkNotNullExpressionValue((Object)periodDuration4, (String)"{\n            val format\u2026)\n            )\n        }");
        }
        return periodDuration;
    }

    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        return ColumnEncoderDecoder.DefaultImpls.decode((ColumnEncoderDecoder)this, (ColumnData)kind, (ByteBuf)value, (Charset)charset);
    }

    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding((ColumnEncoderDecoder)this);
    }

    static {
        PeriodFormatterBuilder periodFormatterBuilder = new PeriodFormatterBuilder().appendLiteral("@ ");
        Intrinsics.checkNotNullExpressionValue((Object)periodFormatterBuilder, (String)"PeriodFormatterBuilder().appendLiteral(\"@ \")");
        postgres_verboseParser = INSTANCE.postgresYMDBuilder(periodFormatterBuilder).appendHours().appendSuffix(" hour", " hours").appendSeparator(" ").appendMinutes().appendSuffix(" min", " mins").appendSeparator(" ").appendSecondsWithOptionalMillis().appendSuffix(" sec", " secs").toFormatter();
        hmsParser = INSTANCE.postgresHMSBuilder(new PeriodFormatterBuilder()).toFormatter();
        PeriodFormatterBuilder periodFormatterBuilder2 = INSTANCE.postgresYMDBuilder(new PeriodFormatterBuilder());
        Intrinsics.checkNotNullExpressionValue((Object)periodFormatterBuilder2, (String)"postgresYMDBuilder(PeriodFormatterBuilder())");
        postgresParser = INSTANCE.postgresHMSBuilder(periodFormatterBuilder2).toFormatter();
        sqlDTParser = INSTANCE.sqlDTBuilder(new PeriodFormatterBuilder()).toFormatter();
        PeriodFormatterBuilder periodFormatterBuilder3 = new PeriodFormatterBuilder().printZeroAlways().rejectSignedValues(true).appendYears().appendSeparator("-").appendMonths().rejectSignedValues(false).printZeroNever().appendSeparator(" ");
        Intrinsics.checkNotNullExpressionValue((Object)periodFormatterBuilder3, (String)"PeriodFormatterBuilder()\u2026    .appendSeparator(\" \")");
        sqlParser = INSTANCE.sqlDTBuilder(periodFormatterBuilder3).toFormatter();
    }
}

