/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.parsers;

import com.github.jasync.sql.db.exceptions.UnsupportedAuthenticationMethodException;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationCleartextPasswordMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationMD5PasswordMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationSASLContinueMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationSASLFinalMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationSASLMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ServerMessage;
import com.github.jasync.sql.db.postgresql.parsers.MessageParser;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/jasync/sql/db/postgresql/parsers/AuthenticationStartupParser;", "Lcom/github/jasync/sql/db/postgresql/parsers/MessageParser;", "()V", "AuthenticationCleartextPassword", "", "AuthenticationGSS", "AuthenticationGSSContinue", "AuthenticationKerberosV5", "AuthenticationMD5Password", "AuthenticationOk", "AuthenticationSASL", "AuthenticationSASLContinue", "AuthenticationSASLFinal", "AuthenticationSCMCredential", "AuthenticationSSPI", "parseMessage", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ServerMessage;", "buffer", "Lio/netty/buffer/ByteBuf;", "parseSASLMechanismIds", "", "", "bytes", "", "jasync-postgresql"})
@SourceDebugExtension(value={"SMAP\nAuthenticationStartupParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticationStartupParser.kt\ncom/github/jasync/sql/db/postgresql/parsers/AuthenticationStartupParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n1#2:60\n13586#3,2:61\n*S KotlinDebug\n*F\n+ 1 AuthenticationStartupParser.kt\ncom/github/jasync/sql/db/postgresql/parsers/AuthenticationStartupParser\n*L\n47#1:61,2\n*E\n"})
public final class AuthenticationStartupParser
implements MessageParser {
    @NotNull
    public static final AuthenticationStartupParser INSTANCE = new AuthenticationStartupParser();
    public static final int AuthenticationOk = 0;
    public static final int AuthenticationKerberosV5 = 2;
    public static final int AuthenticationCleartextPassword = 3;
    public static final int AuthenticationMD5Password = 5;
    public static final int AuthenticationSCMCredential = 6;
    public static final int AuthenticationGSS = 7;
    public static final int AuthenticationGSSContinue = 8;
    public static final int AuthenticationSSPI = 9;
    public static final int AuthenticationSASL = 10;
    public static final int AuthenticationSASLContinue = 11;
    public static final int AuthenticationSASLFinal = 12;

    private AuthenticationStartupParser() {
    }

    @Override
    @NotNull
    public ServerMessage parseMessage(@NotNull ByteBuf buffer) {
        ServerMessage serverMessage;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int authenticationType = buffer.readInt();
        byte[] it = byArray = new byte[buffer.readableBytes()];
        boolean bl = false;
        buffer.readBytes(it);
        byte[] bytes = byArray;
        switch (authenticationType) {
            case 0: {
                serverMessage = AuthenticationOkMessage.INSTANCE;
                break;
            }
            case 3: {
                serverMessage = AuthenticationCleartextPasswordMessage.INSTANCE;
                break;
            }
            case 5: {
                serverMessage = new AuthenticationMD5PasswordMessage(bytes);
                break;
            }
            case 10: {
                serverMessage = new AuthenticationSASLMessage(this.parseSASLMechanismIds(bytes));
                break;
            }
            case 11: {
                serverMessage = new AuthenticationSASLContinueMessage(StringsKt.decodeToString((byte[])bytes));
                break;
            }
            case 12: {
                serverMessage = new AuthenticationSASLFinalMessage(StringsKt.decodeToString((byte[])bytes));
                break;
            }
            default: {
                throw new UnsupportedAuthenticationMethodException(authenticationType);
            }
        }
        return serverMessage;
    }

    @NotNull
    public final List<String> parseSASLMechanismIds(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        List supportedMechanismStrings = new ArrayList();
        StringBuilder builder = new StringBuilder();
        byte[] $this$forEach$iv = bytes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            StringBuilder stringBuilder;
            byte element$iv;
            byte by = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (by != 0) {
                builder.append((char)by);
                continue;
            }
            StringBuilder it = stringBuilder = builder;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = ((CharSequence)it).length() > 0 ? stringBuilder : null;
            if (stringBuilder2 != null) {
                it = stringBuilder2;
                boolean bl3 = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                supportedMechanismStrings.add(string);
            }
            StringsKt.clear((StringBuilder)builder);
        }
        return supportedMechanismStrings;
    }
}

