/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.parsers;

import com.github.jasync.sql.db.exceptions.ParserNotAvailableException;
import com.github.jasync.sql.db.postgresql.messages.backend.ServerMessage;
import com.github.jasync.sql.db.postgresql.parsers.AuthenticationStartupParser;
import com.github.jasync.sql.db.postgresql.parsers.BackendKeyDataParser;
import com.github.jasync.sql.db.postgresql.parsers.CommandCompleteParser;
import com.github.jasync.sql.db.postgresql.parsers.DataRowParser;
import com.github.jasync.sql.db.postgresql.parsers.ErrorParser;
import com.github.jasync.sql.db.postgresql.parsers.MessageParser;
import com.github.jasync.sql.db.postgresql.parsers.NoticeParser;
import com.github.jasync.sql.db.postgresql.parsers.NotificationResponseParser;
import com.github.jasync.sql.db.postgresql.parsers.ParameterStatusParser;
import com.github.jasync.sql.db.postgresql.parsers.ReadyForQueryParser;
import com.github.jasync.sql.db.postgresql.parsers.ReturningMessageParser;
import com.github.jasync.sql.db.postgresql.parsers.RowDescriptionParser;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/jasync/sql/db/postgresql/parsers/MessageParsersRegistry;", "", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "commandCompleteParser", "Lcom/github/jasync/sql/db/postgresql/parsers/CommandCompleteParser;", "errorParser", "Lcom/github/jasync/sql/db/postgresql/parsers/ErrorParser;", "noticeParser", "Lcom/github/jasync/sql/db/postgresql/parsers/NoticeParser;", "notificationResponseParser", "Lcom/github/jasync/sql/db/postgresql/parsers/NotificationResponseParser;", "parameterStatusParser", "Lcom/github/jasync/sql/db/postgresql/parsers/ParameterStatusParser;", "rowDescriptionParser", "Lcom/github/jasync/sql/db/postgresql/parsers/RowDescriptionParser;", "parse", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ServerMessage;", "t", "", "b", "Lio/netty/buffer/ByteBuf;", "parserFor", "Lcom/github/jasync/sql/db/postgresql/parsers/MessageParser;", "jasync-postgresql"})
public final class MessageParsersRegistry {
    @NotNull
    private final Charset charset;
    @NotNull
    private final CommandCompleteParser commandCompleteParser;
    @NotNull
    private final ErrorParser errorParser;
    @NotNull
    private final NoticeParser noticeParser;
    @NotNull
    private final ParameterStatusParser parameterStatusParser;
    @NotNull
    private final RowDescriptionParser rowDescriptionParser;
    @NotNull
    private final NotificationResponseParser notificationResponseParser;

    public MessageParsersRegistry(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
        this.commandCompleteParser = new CommandCompleteParser(this.charset);
        this.errorParser = new ErrorParser(this.charset);
        this.noticeParser = new NoticeParser(this.charset);
        this.parameterStatusParser = new ParameterStatusParser(this.charset);
        this.rowDescriptionParser = new RowDescriptionParser(this.charset);
        this.notificationResponseParser = new NotificationResponseParser(this.charset);
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    private final MessageParser parserFor(int t) {
        MessageParser messageParser;
        switch (t) {
            case 82: {
                messageParser = AuthenticationStartupParser.INSTANCE;
                break;
            }
            case 75: {
                messageParser = BackendKeyDataParser.INSTANCE;
                break;
            }
            case 50: {
                messageParser = ReturningMessageParser.BindCompleteMessageParser;
                break;
            }
            case 51: {
                messageParser = ReturningMessageParser.CloseCompleteMessageParser;
                break;
            }
            case 67: {
                messageParser = this.commandCompleteParser;
                break;
            }
            case 68: {
                messageParser = DataRowParser.INSTANCE;
                break;
            }
            case 69: {
                messageParser = this.errorParser;
                break;
            }
            case 73: {
                messageParser = ReturningMessageParser.EmptyQueryStringMessageParser;
                break;
            }
            case 110: {
                messageParser = ReturningMessageParser.NoDataMessageParser;
                break;
            }
            case 78: {
                messageParser = this.noticeParser;
                break;
            }
            case 65: {
                messageParser = this.notificationResponseParser;
                break;
            }
            case 83: {
                messageParser = this.parameterStatusParser;
                break;
            }
            case 49: {
                messageParser = ReturningMessageParser.ParseCompleteMessageParser;
                break;
            }
            case 84: {
                messageParser = this.rowDescriptionParser;
                break;
            }
            case 90: {
                messageParser = ReadyForQueryParser.INSTANCE;
                break;
            }
            default: {
                throw new ParserNotAvailableException((byte)t);
            }
        }
        return messageParser;
    }

    @NotNull
    public final ServerMessage parse(int t, @NotNull ByteBuf b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.parserFor(t).parseMessage(b);
    }
}

