/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.compiler;

import com.github.fge.compiler.CompilerOutput;
import com.github.fge.compiler.CompilerOutputDirectory;
import com.github.fge.compiler.CompilingException;
import com.github.fge.compiler.DevNull;
import com.github.fge.compiler.DiagnosticsReporting;
import com.github.fge.compiler.FromStringFileObject;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.google.common.collect.ImmutableList;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public final class CompilerProcessor
implements Processor<ValueHolder<String>, CompilerOutput> {
    private static final JavaCompiler COMPILER = ToolProvider.getSystemJavaCompiler();
    private static final String CANNOT_FIND_COMPILER = "cannot find system compiler (do you have a JDK installed?)";
    private static final String CANNOT_FIND_PACKAGENAME = "cannot extract package name from source";
    private static final String CANNOT_FIND_CLASSNAME = "cannot extract class name from source";
    private static final String CANNOT_BUILD_URI = "cannot build URI from class name";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^package\\s+(\\w+(\\.\\w+)*);", 8);
    private static final Pattern CLASSNAME_PATTERN = Pattern.compile("^public\\s+(?:final\\s+)?class\\s+(\\w+)", 8);

    public CompilerOutput process(ProcessingReport report, ValueHolder<String> input) throws ProcessingException {
        FromStringFileObject fileObject;
        if (COMPILER == null) {
            throw new CompilingException(CANNOT_FIND_COMPILER);
        }
        String source = (String)input.getValue();
        String packageName = CompilerProcessor.extractPkgName(source);
        if (packageName == null) {
            throw new CompilingException(CANNOT_FIND_PACKAGENAME);
        }
        String className = CompilerProcessor.extractClassName(source);
        if (className == null) {
            throw new CompilingException(CANNOT_FIND_CLASSNAME);
        }
        String fullName = packageName + '.' + className;
        try {
            fileObject = new FromStringFileObject(fullName, source);
        }
        catch (URISyntaxException e) {
            throw new CompilingException(new ProcessingMessage().setMessage(CANNOT_BUILD_URI).put("className", fullName), e);
        }
        CompilerOutputDirectory outputDirectory = new CompilerOutputDirectory(fullName);
        CompilerOutput output = new CompilerOutput(outputDirectory);
        CompilerProcessor.doCompile(output, fileObject, report);
        return output;
    }

    private static String extractPkgName(String source) {
        Matcher m = PACKAGE_PATTERN.matcher(source);
        return m.find() ? m.group(1) : null;
    }

    private static String extractClassName(String source) {
        Matcher m = CLASSNAME_PATTERN.matcher(source);
        return m.find() ? m.group(1) : null;
    }

    private static void doCompile(CompilerOutput output, JavaFileObject fileObject, ProcessingReport report) throws ProcessingException {
        String directory = output.getDirectory().getDirectory();
        ImmutableList options = ImmutableList.of((Object)"-d", (Object)directory);
        DiagnosticsReporting reporting = new DiagnosticsReporting();
        StandardJavaFileManager manager = COMPILER.getStandardFileManager(null, Locale.ENGLISH, Charset.forName("UTF-8"));
        JavaCompiler.CompilationTask task = COMPILER.getTask(DevNull.getInstance(), manager, reporting, (Iterable<String>)options, null, (Iterable<? extends JavaFileObject>)ImmutableList.of((Object)fileObject));
        task.call();
        report.mergeWith(reporting.getReport());
    }
}

