/*
 * Decompiled with CFR 0.152.
 */
package g0801_0900.s0815_bus_routes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class Solution {
    public int numBusesToDestination(int[][] routes, int source, int target) {
        if (source == target) {
            return 0;
        }
        HashSet<Integer> targetRoutes = new HashSet<Integer>();
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        boolean[] taken = new boolean[routes.length];
        List<Integer>[] graph = this.buildGraph(routes, source, target, queue, targetRoutes, taken);
        if (targetRoutes.isEmpty()) {
            return -1;
        }
        int bus = 1;
        while (!queue.isEmpty()) {
            int size = queue.size();
            for (int i = 0; i < size; ++i) {
                int route = (Integer)queue.poll();
                if (targetRoutes.contains(route)) {
                    return bus;
                }
                for (int nextRoute : graph[route]) {
                    if (taken[nextRoute]) continue;
                    queue.offer(nextRoute);
                    taken[nextRoute] = true;
                }
            }
            ++bus;
        }
        return -1;
    }

    private List<Integer>[] buildGraph(int[][] routes, int source, int target, Queue<Integer> queue, Set<Integer> targetRoutes, boolean[] taken) {
        int i;
        int len = routes.length;
        ArrayList[] graph = new ArrayList[len];
        for (i = 0; i < len; ++i) {
            Arrays.sort(routes[i]);
            graph[i] = new ArrayList();
            int id = Arrays.binarySearch(routes[i], source);
            if (id >= 0) {
                queue.offer(i);
                taken[i] = true;
            }
            if ((id = Arrays.binarySearch(routes[i], target)) < 0) continue;
            targetRoutes.add(i);
        }
        for (i = 0; i < len; ++i) {
            for (int j = i + 1; j < len; ++j) {
                if (!this.commonStop(routes[i], routes[j])) continue;
                graph[i].add(j);
                graph[j].add(i);
            }
        }
        return graph;
    }

    private boolean commonStop(int[] routeA, int[] routeB) {
        int idA = 0;
        int idB = 0;
        while (idA < routeA.length && idB < routeB.length) {
            if (routeA[idA] == routeB[idB]) {
                return true;
            }
            if (routeA[idA] < routeB[idB]) {
                ++idA;
                continue;
            }
            ++idB;
        }
        return false;
    }
}

