/*
 * Decompiled with CFR 0.152.
 */
package g1201_1300.s1206_design_skiplist;

public class Skiplist {
    private static final int INIT_CAPACITY = 8;
    private final int minBoundary;
    private final Node head;
    private int headCapacity;
    private int headLevel = 0;

    public Skiplist() {
        this(8);
    }

    public Skiplist(int size) {
        if (size == 0) {
            throw new IllegalArgumentException("size should be greater than 0");
        }
        if (size < 8) {
            size = 8;
        }
        this.minBoundary = size / 2;
        this.headCapacity = size;
        this.head = new Node(0, size);
    }

    public boolean search(int target) {
        Node curr = this.head;
        for (int i = this.headLevel - 1; i >= 0; --i) {
            int cmp;
            while (curr.next[i] != null && (cmp = target - curr.next[i].val) >= 0) {
                if (cmp > 0) {
                    curr = curr.next[i];
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public void add(int num) {
        Node[] update = new Node[this.headLevel + 1];
        update[this.headLevel] = this.head;
        this.buildUpdate(num, update);
        int level = this.getRandomLevel();
        if (level > this.headLevel) {
            if (this.headLevel == this.headCapacity) {
                this.resizeHead(2 * this.headCapacity);
            }
            ++this.headLevel;
        }
        Node x = new Node(num, level);
        for (int i = 0; i < level; ++i) {
            Node n = update[i].next[i];
            ((Node)update[i]).next[i] = x;
            ((Node)x).next[i] = n;
        }
    }

    public boolean erase(int num) {
        if (this.headLevel == 0) {
            return false;
        }
        Node[] update = new Node[this.headLevel];
        this.buildUpdate(num, update);
        if (update[0].next[0] == null || update[0].next[0].val != num) {
            return false;
        }
        for (int i = 0; i < this.headLevel && update[i].next[i] != null && update[i].next[i].val == num; ++i) {
            ((Node)update[i]).next[i] = update[i].next[i].next[i];
        }
        if (this.head.next[this.headLevel - 1] == null && --this.headLevel >= this.minBoundary && this.headLevel == this.headCapacity / 4) {
            this.resizeHead(this.headCapacity / 2);
        }
        return true;
    }

    private void buildUpdate(int x, Node[] update) {
        Node curr = this.head;
        for (int i = this.headLevel - 1; i >= 0; --i) {
            while (curr.next[i] != null && curr.next[i].val < x) {
                curr = curr.next[i];
            }
            update[i] = curr;
        }
    }

    private int getRandomLevel() {
        int level;
        int maxLevel = 14;
        int limit = Math.min(maxLevel, this.headLevel + 1);
        double p = 0.5;
        for (level = 1; Math.random() < p && level < limit; ++level) {
        }
        return level;
    }

    private void resizeHead(int size) {
        Node[] copy = new Node[size];
        System.arraycopy(this.head.next, 0, copy, 0, this.headLevel);
        Node.access$102(this.head, copy);
        this.headCapacity = size;
    }

    private static class Node {
        private final int val;
        private Node[] next;

        private Node(int val, int level) {
            this.val = val;
            this.next = new Node[level];
        }

        static /* synthetic */ Node[] access$102(Node x0, Node[] x1) {
            x0.next = x1;
            return x1;
        }
    }
}

