/*
 * Decompiled with CFR 0.152.
 */
package g1701_1800.s1797_design_authentication_manager;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationManager {
    int inc;
    Map<String, Integer> expireMap;
    Deque<Item> deque = new ArrayDeque<Item>();

    public AuthenticationManager(int timeToLive) {
        this.expireMap = new HashMap<String, Integer>();
        this.inc = timeToLive;
    }

    public void generate(String tokenId, int currentTime) {
        this.expireMap.put(tokenId, currentTime + this.inc);
        this.deque.offerLast(new Item(tokenId, currentTime + this.inc));
    }

    public void renew(String tokenId, int currentTime) {
        this.update(currentTime);
        if (this.expireMap.containsKey(tokenId)) {
            this.deque.offerLast(new Item(tokenId, currentTime + this.inc));
            this.expireMap.put(tokenId, currentTime + this.inc);
        }
    }

    public int countUnexpiredTokens(int currentTime) {
        this.update(currentTime);
        return this.expireMap.size();
    }

    private void update(int curTime) {
        while (!this.deque.isEmpty() && this.deque.peekFirst().time <= curTime) {
            String id = this.deque.peekFirst().id;
            int time = this.deque.peekFirst().time;
            if (this.expireMap.containsKey(id) && this.expireMap.get(id).equals(time)) {
                this.expireMap.remove(this.deque.pollFirst().id);
                continue;
            }
            this.deque.pollFirst();
        }
    }

    private static class Item {
        String id;
        int time;

        Item(String id, int time) {
            this.id = id;
            this.time = time;
        }
    }
}

