/*
 * Decompiled with CFR 0.152.
 */
package g1901_2000.s1928_minimum_cost_to_reach_destination_in_time;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class Solution {
    public int minCost(int maxTime, int[][] edges, int[] passingFees) {
        PriorityQueue<Tuple> pq = new PriorityQueue<Tuple>((a, b) -> a.cost == b.cost ? a.time - b.time : a.cost - b.cost);
        int n = passingFees.length;
        int[] minTime = new int[n];
        Arrays.fill(minTime, Integer.MAX_VALUE);
        Graph graph = new Graph();
        for (int[] edge : edges) {
            graph.addEdge(edge[0], edge[1], edge[2]);
        }
        pq.offer(new Tuple(0, passingFees[0], 0));
        while (!pq.isEmpty()) {
            Tuple curr = (Tuple)pq.poll();
            if (curr.time > maxTime || curr.time >= minTime[curr.node]) continue;
            minTime[curr.node] = curr.time;
            if (curr.node == n - 1) {
                return curr.cost;
            }
            for (Edge edge : graph.getEdges(curr.node)) {
                int time = curr.time + edge.weight;
                if (time > maxTime || time >= minTime[edge.dst]) continue;
                pq.offer(new Tuple(edge.dst, curr.cost + passingFees[edge.dst], time));
            }
        }
        return -1;
    }

    private static class Tuple {
        private final int node;
        private final int cost;
        private final int time;

        private Tuple(int node, int cost, int time) {
            this.node = node;
            this.cost = cost;
            this.time = time;
        }
    }

    private static final class Edge {
        private final int dst;
        private final int weight;

        private Edge(int dst, int weight) {
            this.dst = dst;
            this.weight = weight;
        }
    }

    private static class Graph {
        private final Map<Integer, List<Edge>> edges = new HashMap<Integer, List<Edge>>();

        private Graph() {
        }

        private void addEdge(int src, int dst, int weight) {
            this.edges.computeIfAbsent(src, k -> new ArrayList()).add(new Edge(dst, weight));
            this.edges.computeIfAbsent(dst, k -> new ArrayList()).add(new Edge(src, weight));
        }

        private List<Edge> getEdges(int node) {
            return this.edges.getOrDefault(node, new ArrayList());
        }
    }
}

