/*
 * Decompiled with CFR 0.152.
 */
package g0401_0500.s0497_random_point_in_non_overlapping_rectangles;

import java.util.Random;

public class Solution {
    private final int[] weights;
    private final int[][] rects;
    private final Random random;

    public Solution(int[][] rects) {
        this.weights = new int[rects.length];
        this.rects = rects;
        this.random = new Random();
        for (int i = 0; i < rects.length; ++i) {
            int[] rect = rects[i];
            int count = (1 + rect[2] - rect[0]) * (1 + rect[3] - rect[1]);
            this.weights[i] = (i == 0 ? 0 : this.weights[i - 1]) + count;
        }
    }

    public int[] pick() {
        int picked = 1 + this.random.nextInt(this.weights[this.weights.length - 1]);
        int idx = this.findGreaterOrEqual(picked);
        return this.getRandomPoint(idx);
    }

    private int findGreaterOrEqual(int target) {
        int left = 0;
        int right = this.weights.length - 1;
        while (left + 1 < right) {
            int mid = left + (right - left) / 2;
            if (this.weights[mid] >= target) {
                right = mid;
                continue;
            }
            left = mid + 1;
        }
        return this.weights[left] >= target ? left : right;
    }

    private int[] getRandomPoint(int idx) {
        int[] r = this.rects[idx];
        int left = r[0];
        int right = r[2];
        int bot = r[1];
        int top = r[3];
        return new int[]{left + this.random.nextInt(right - left + 1), bot + this.random.nextInt(top - bot + 1)};
    }
}

