/*
 * Decompiled with CFR 0.152.
 */
package g2301_2400.s2353_design_a_food_rating_system;

import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;

public class FoodRatings {
    private HashMap<String, TreeSet<Food>> cus = new HashMap();
    private HashMap<String, Food> foodHashMap = new HashMap();

    public FoodRatings(String[] foods, String[] cuisines, int[] ratings) {
        for (int i = 0; i < foods.length; ++i) {
            Food food = new Food(foods[i], ratings[i], cuisines[i]);
            this.foodHashMap.put(foods[i], food);
            if (this.cus.containsKey(cuisines[i])) {
                this.cus.get(cuisines[i]).add(food);
                continue;
            }
            TreeSet<Food> pq = new TreeSet<Food>(new Comp());
            pq.add(food);
            this.cus.put(cuisines[i], pq);
        }
    }

    public void changeRating(String food, int newRating) {
        Food dish = this.foodHashMap.get(food);
        TreeSet<Food> pq = this.cus.get(dish.cus);
        pq.remove(dish);
        dish.rating = newRating;
        pq.add(dish);
    }

    public String highestRated(String cuisine) {
        return this.cus.get((Object)cuisine).first().foodItem;
    }

    private static class Food {
        private String foodItem;
        private String cus;
        private int rating;

        Food(String food, int rating, String cus) {
            this.foodItem = food;
            this.rating = rating;
            this.cus = cus;
        }
    }

    private static class Comp
    implements Comparator<Food> {
        private Comp() {
        }

        @Override
        public int compare(Food f1, Food f2) {
            if (f1.rating == f2.rating) {
                return f1.foodItem.compareTo(f2.foodItem);
            }
            return Integer.compare(f2.rating, f1.rating);
        }
    }
}

