/*
 * Decompiled with CFR 0.152.
 */
package g0301_0400.s0355_design_twitter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Twitter {
    private Map<Integer, HashSet<Integer>> twitterData;
    private Tweet head = new Tweet(-1, -1);

    public Twitter() {
        this.twitterData = new HashMap<Integer, HashSet<Integer>>();
    }

    public void postTweet(int userId, int tweetId) {
        this.checkNewUser(userId);
        Tweet t = new Tweet(userId, tweetId);
        Tweet next = this.head.next;
        this.head.next = t;
        t.next = next;
    }

    public List<Integer> getNewsFeed(int userId) {
        this.checkNewUser(userId);
        ArrayList<Integer> res = new ArrayList<Integer>();
        HashSet<Integer> followers = this.twitterData.get(userId);
        Tweet t = this.head.next;
        while (t != null && res.size() < 10) {
            if (followers.contains(t.userId)) {
                res.add(t.tweetId);
            }
            t = t.next;
        }
        return res;
    }

    public void follow(int followerId, int followeeId) {
        this.checkNewUser(followeeId);
        this.checkNewUser(followerId);
        this.twitterData.get(followerId).add(followeeId);
    }

    public void unfollow(int followerId, int followeeId) {
        this.checkNewUser(followeeId);
        if (followerId == followeeId) {
            return;
        }
        this.checkNewUser(followerId);
        this.twitterData.get(followerId).remove(followeeId);
    }

    public void checkNewUser(int userId) {
        if (this.twitterData.containsKey(userId)) {
            return;
        }
        this.twitterData.put(userId, new HashSet());
        this.twitterData.get(userId).add(userId);
    }

    private static class Tweet {
        int userId;
        int tweetId;
        Tweet next;

        Tweet(int uId, int tId) {
            this.userId = uId;
            this.tweetId = tId;
        }
    }
}

