/*
 * Decompiled with CFR 0.152.
 */
package g0401_0500.s0460_lfu_cache;

import java.util.HashMap;
import java.util.Map;

public class LFUCache {
    private final Map<Integer, Node> endOfBlock = new HashMap<Integer, Node>();
    private final Map<Integer, Node> map = new HashMap<Integer, Node>();
    private final int capacity;
    private final Node linkedList;

    public LFUCache(int capacity) {
        this.capacity = capacity;
        this.linkedList = new Node();
    }

    public int get(int key) {
        if (this.map.containsKey(key)) {
            Node newEndNode = this.map.get(key);
            Node currEndNode = this.endOfBlock.get(newEndNode.freq);
            if (currEndNode == newEndNode) {
                this.findNewEndOfBlock(newEndNode);
                if (currEndNode.next == null || currEndNode.next.freq > newEndNode.freq + 1) {
                    ++newEndNode.freq;
                    this.endOfBlock.put(newEndNode.freq, newEndNode);
                    return newEndNode.val;
                }
            }
            if (newEndNode.next != null) {
                newEndNode.next.prev = newEndNode.prev;
            }
            newEndNode.prev.next = newEndNode.next;
            ++newEndNode.freq;
            Node endNode = currEndNode.next == null || currEndNode.next.freq > newEndNode.freq ? currEndNode : this.endOfBlock.get(newEndNode.freq);
            this.endOfBlock.put(newEndNode.freq, newEndNode);
            if (endNode.next != null) {
                endNode.next.prev = newEndNode;
            }
            newEndNode.next = endNode.next;
            endNode.next = newEndNode;
            newEndNode.prev = endNode;
            return newEndNode.val;
        }
        return -1;
    }

    public void put(int key, int value) {
        if (this.capacity == 0) {
            return;
        }
        if (this.map.containsKey(key)) {
            this.map.get((Object)Integer.valueOf((int)key)).val = value;
            this.get(key);
        } else {
            if (this.map.size() == this.capacity) {
                Node toDelete = this.linkedList.next;
                this.map.remove(toDelete.key);
                if (toDelete.next != null) {
                    toDelete.next.prev = this.linkedList;
                }
                this.linkedList.next = toDelete.next;
                if (this.endOfBlock.get(toDelete.freq) == toDelete) {
                    this.endOfBlock.remove(toDelete.freq);
                }
            }
            Node newEndNode = new Node();
            newEndNode.key = key;
            newEndNode.val = value;
            newEndNode.freq = 1;
            this.map.put(key, newEndNode);
            Node endNode = this.endOfBlock.getOrDefault(1, this.linkedList);
            this.endOfBlock.put(1, newEndNode);
            if (endNode.next != null) {
                endNode.next.prev = newEndNode;
            }
            newEndNode.next = endNode.next;
            endNode.next = newEndNode;
            newEndNode.prev = endNode;
        }
    }

    private void findNewEndOfBlock(Node node) {
        Node prev = node.prev;
        if (prev.freq == node.freq) {
            this.endOfBlock.put(node.freq, prev);
        } else {
            this.endOfBlock.remove(node.freq);
        }
    }

    private static class Node {
        Node prev;
        Node next;
        int key = -1;
        int val;
        int freq;

        private Node() {
        }
    }
}

