/*
 * Decompiled with CFR 0.152.
 */
package g0701_0800.s0770_basic_calculator_iv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Solution {
    private Map<String, Integer> evalMap;
    private int i = 0;

    public List<String> basicCalculatorIV(String expression, String[] evalvars, int[] evalints) {
        this.evalMap = new HashMap<String, Integer>();
        for (int j = 0; j < evalvars.length; ++j) {
            this.evalMap.put(evalvars[j], evalints[j]);
        }
        this.i = -1;
        this.next(expression);
        Result res = this.expression(expression);
        return res.toList();
    }

    private Result expression(String s) {
        Result res = this.term(s);
        while (this.i < s.length() && (s.charAt(this.i) == '+' || s.charAt(this.i) == '-')) {
            char c = s.charAt(this.i);
            this.next(s);
            if (c == '+') {
                res = this.add(res, this.term(s));
                continue;
            }
            res = this.subtract(res, this.term(s));
        }
        return res;
    }

    private Result term(String s) {
        Result res = this.factor(s);
        while (this.i < s.length() && s.charAt(this.i) == '*') {
            this.next(s);
            res = this.multiply(res, this.factor(s));
        }
        return res;
    }

    private Result multiply(Result r1, Result r2) {
        Map<List<String>, Integer> map1 = r1.getMap();
        Map<List<String>, Integer> map2 = r2.getMap();
        HashMap<List<String>, Integer> map = new HashMap<List<String>, Integer>();
        for (Map.Entry<List<String>, Integer> entry1 : map1.entrySet()) {
            for (Map.Entry<List<String>, Integer> entry2 : map2.entrySet()) {
                ArrayList key = new ArrayList(entry1.getKey());
                key.addAll(entry2.getKey());
                Collections.sort(key);
                map.put(key, map.getOrDefault(key, 0) + entry1.getValue() * entry2.getValue());
            }
        }
        return new Result(map);
    }

    private Result add(Result r1, Result r2) {
        Map<List<String>, Integer> map1 = r1.getMap();
        Map<List<String>, Integer> map2 = r2.getMap();
        HashMap<List<String>, Integer> map = new HashMap<List<String>, Integer>();
        for (Map.Entry<List<String>, Integer> entry1 : map1.entrySet()) {
            map.put(entry1.getKey(), map.getOrDefault(entry1.getKey(), 0) + entry1.getValue());
        }
        for (Map.Entry<List<String>, Integer> entry2 : map2.entrySet()) {
            map.put(entry2.getKey(), map.getOrDefault(entry2.getKey(), 0) + entry2.getValue());
        }
        return new Result(map);
    }

    private Result subtract(Result r1, Result r2) {
        Map<List<String>, Integer> map1 = r1.getMap();
        Map<List<String>, Integer> map2 = r2.getMap();
        HashMap<List<String>, Integer> map = new HashMap<List<String>, Integer>();
        for (Map.Entry<List<String>, Integer> entry1 : map1.entrySet()) {
            map.put(entry1.getKey(), map.getOrDefault(entry1.getKey(), 0) + entry1.getValue());
        }
        for (Map.Entry<List<String>, Integer> entry2 : map2.entrySet()) {
            map.put(entry2.getKey(), map.getOrDefault(entry2.getKey(), 0) - entry2.getValue());
        }
        return new Result(map);
    }

    private Result factor(String s) {
        Result res = new Result();
        if (s.charAt(this.i) == '(') {
            this.next(s);
            res = this.expression(s);
            this.next(s);
            return res;
        }
        if (Character.isLowerCase(s.charAt(this.i))) {
            return this.identifier(s);
        }
        res.update(new ArrayList<String>(), this.number(s));
        return res;
    }

    private Result identifier(String s) {
        Result res = new Result();
        StringBuilder sb = new StringBuilder();
        while (this.i < s.length() && Character.isLowerCase(s.charAt(this.i))) {
            sb.append(s.charAt(this.i));
            ++this.i;
        }
        --this.i;
        this.next(s);
        String variable = sb.toString();
        if (this.evalMap.containsKey(variable)) {
            res.update(new ArrayList<String>(), this.evalMap.get(variable));
        } else {
            ArrayList<String> key = new ArrayList<String>();
            key.add(variable);
            res.update(key, 1);
        }
        return res;
    }

    private int number(String s) {
        int res = 0;
        while (this.i < s.length() && s.charAt(this.i) >= '0' && s.charAt(this.i) <= '9') {
            res = res * 10 + (s.charAt(this.i) - 48);
            ++this.i;
        }
        --this.i;
        this.next(s);
        return res;
    }

    private void next(String s) {
        ++this.i;
        while (this.i < s.length() && s.charAt(this.i) == ' ') {
            ++this.i;
        }
    }

    private static class Result {
        private Map<List<String>, Integer> map;

        Result() {
            this.map = new HashMap<List<String>, Integer>();
        }

        Result(Map<List<String>, Integer> map) {
            this.map = map;
        }

        void update(List<String> key, int val) {
            this.map.put(key, this.map.getOrDefault(key, 0) + val);
        }

        Map<List<String>, Integer> getMap() {
            return this.map;
        }

        List<String> toList() {
            ArrayList<List<String>> keyList = new ArrayList<List<String>>(this.map.keySet());
            HashMap<List, String> list2String = new HashMap<List, String>();
            for (List list : keyList) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String k : list) {
                    stringBuilder.append(k).append("*");
                }
                list2String.put(list, stringBuilder.toString());
            }
            keyList.sort((a, b) -> a.size() == b.size() ? ((String)list2String.get(a)).compareTo((String)list2String.get(b)) : b.size() - a.size());
            ArrayList<String> res = new ArrayList<String>();
            for (List list : keyList) {
                if (this.map.get(list) == 0) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(this.map.get(list));
                for (String k : list) {
                    sb.append("*").append(k);
                }
                res.add(sb.toString());
            }
            return res;
        }
    }
}

