/*
 * Decompiled with CFR 0.152.
 */
package g0901_1000.s0981_time_based_key_value_store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TimeMap {
    private Map<String, List<TimeStampData>> map = new HashMap<String, List<TimeStampData>>();

    public void set(String key, String value, int timestamp) {
        if (!this.map.containsKey(key)) {
            ArrayList<TimeStampData> timeStampDataList = new ArrayList<TimeStampData>();
            timeStampDataList.add(new TimeStampData(timestamp, value));
            this.map.put(key, timeStampDataList);
        } else {
            this.map.get(key).add(new TimeStampData(timestamp, value));
        }
    }

    public String get(String key, int timestamp) {
        if (!this.map.containsKey(key)) {
            return "";
        }
        List<TimeStampData> list = this.map.get(key);
        int start = 0;
        int end = list.size() - 1;
        while (start <= end) {
            int mid = start + (end - start) / 2;
            if (list.get((int)mid).timestamp == timestamp) {
                return list.get((int)mid).value;
            }
            if (timestamp > list.get((int)mid).timestamp) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end < 0 ? "" : list.get((int)end).value;
    }

    private static class TimeStampData {
        int timestamp;
        String value;

        TimeStampData(int timestamp, String value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

