/*
 * Decompiled with CFR 0.152.
 */
package g1901_2000.s1931_painting_a_grid_with_three_different_colors;

import java.util.HashMap;
import java.util.Map;

public class Solution {
    public static final int P = 1000000007;

    public int colorTheGrid(int m, int n) {
        if (m == 1) {
            return (int)(3L * (long)this.powMod(2, n - 1) % 1000000007L);
        }
        if (m == 2) {
            return (int)(6L * (long)this.powMod(3, n - 1) % 1000000007L);
        }
        if (n == 1) {
            return (int)(3L * (long)this.powMod(2, m - 1) % 1000000007L);
        }
        if (n == 2) {
            return (int)(6L * (long)this.powMod(3, m - 1) % 1000000007L);
        }
        int totalTemplates = 1 << m - 2;
        int totalPaintings = this.binPow(3, m);
        int[] paintingToTemplate = new int[totalPaintings];
        long[] paintingCountForTemplate = new long[totalTemplates];
        long[][] templateEdgeCount = new long[totalTemplates][totalTemplates];
        HashMap<Integer, Integer> templateToIndex = new HashMap<Integer, Integer>(1 << m - 2);
        int templateCounter = 0;
        this.extracted(m, totalPaintings, paintingToTemplate, paintingCountForTemplate, templateToIndex, templateCounter);
        this.extracted(m, totalPaintings, paintingToTemplate, templateEdgeCount);
        for (int i = 0; i < totalTemplates; ++i) {
            long c = paintingCountForTemplate[i];
            int j = 0;
            while (j < totalTemplates) {
                long[] lArray = templateEdgeCount[i];
                int n2 = j++;
                lArray[n2] = lArray[n2] / c;
            }
        }
        long[][] matrixPower = this.matrixPower(templateEdgeCount, (long)n - 1L);
        long ans = 0L;
        for (int i = 0; i < totalTemplates; ++i) {
            long[] arr;
            long s = 0L;
            for (long a : arr = matrixPower[i]) {
                s += a;
            }
            ans += paintingCountForTemplate[i] * s;
        }
        return (int)(ans % 1000000007L);
    }

    private void extracted(int m, int totalPaintings, int[] paintingToTemplate, long[][] templateEdgeCount) {
        for (int i = 0; i < totalPaintings; ++i) {
            if (paintingToTemplate[i] == -1) continue;
            for (int j = i + 1; j < totalPaintings; ++j) {
                if (paintingToTemplate[j] == -1 || !this.checkAllowance(i, j, m)) continue;
                long[] lArray = templateEdgeCount[paintingToTemplate[i]];
                int n = paintingToTemplate[j];
                lArray[n] = lArray[n] + 1L;
                long[] lArray2 = templateEdgeCount[paintingToTemplate[j]];
                int n2 = paintingToTemplate[i];
                lArray2[n2] = lArray2[n2] + 1L;
            }
        }
    }

    private void extracted(int m, int totalPaintings, int[] paintingToTemplate, long[] paintingCountForTemplate, Map<Integer, Integer> templateToIndex, int templateCounter) {
        for (int i = 0; i < totalPaintings; ++i) {
            int type = this.getType(i, m);
            if (type == -1) {
                paintingToTemplate[i] = -1;
                continue;
            }
            Integer templateIndex = templateToIndex.get(type);
            if (templateIndex == null) {
                templateToIndex.put(type, templateCounter);
                templateIndex = templateCounter++;
            }
            paintingToTemplate[i] = templateIndex;
            int n = templateIndex;
            paintingCountForTemplate[n] = paintingCountForTemplate[n] + 1L;
        }
    }

    private boolean checkAllowance(int a, int b, int m) {
        for (int i = 0; i < m; ++i) {
            if (a % 3 == b % 3) {
                return false;
            }
            a /= 3;
            b /= 3;
        }
        return true;
    }

    private int getType(int a, int m) {
        int[] digits = new int[3];
        int first = a % 3;
        int second = a % 9 / 3;
        if (first == second) {
            return -1;
        }
        digits[second] = 1;
        digits[3 - first - second] = 2;
        int prev = second;
        int type = 1;
        m -= 2;
        a /= 9;
        while (m-- > 0) {
            int curr = a % 3;
            if (prev == curr) {
                return -1;
            }
            type = type * 3 + digits[curr];
            prev = curr;
            a /= 3;
        }
        return type;
    }

    private int powMod(int a, int b) {
        long res = 1L;
        while (b != 0) {
            if ((b & 1) != 0) {
                res = res * (long)a % 1000000007L;
                --b;
                continue;
            }
            a = (int)((long)a * (long)a % 1000000007L);
            b >>= 1;
        }
        return (int)res;
    }

    private int binPow(int a, int n) {
        int res = 1;
        int tmp = a;
        while (n != 0) {
            if ((n & 1) != 0) {
                res *= tmp;
            }
            tmp *= tmp;
            n >>= 1;
        }
        return res;
    }

    private long[][] matrixPower(long[][] base, long pow) {
        int n = base.length;
        long[][] res = new long[n][n];
        for (int i = 0; i < n; ++i) {
            res[i][i] = 1L;
        }
        while (pow != 0L) {
            if ((pow & 1L) != 0L) {
                res = this.multiplyMatrix(res, base);
                --pow;
                continue;
            }
            base = this.multiplyMatrix(base, base);
            pow >>= 1;
        }
        return res;
    }

    private long[][] multiplyMatrix(long[][] a, long[][] b) {
        int n = a.length;
        long[][] ans = new long[n][n];
        for (int i = 0; i < n; ++i) {
            int j = 0;
            while (j < n) {
                for (int k = 0; k < n; ++k) {
                    long[] lArray = ans[i];
                    int n2 = j;
                    lArray[n2] = lArray[n2] + a[i][k] * b[k][j];
                }
                long[] lArray = ans[i];
                int n3 = j++;
                lArray[n3] = lArray[n3] % 1000000007L;
            }
        }
        return ans;
    }
}

