/*
 * Decompiled with CFR 0.152.
 */
package g3101_3200.s3123_find_edges_in_shortest_paths;

import java.util.Arrays;
import java.util.PriorityQueue;

public class Solution {
    private int[] edge;
    private int[] weight;
    private int[] next;
    private int[] head;
    private int index;

    private void add(int u, int v, int w) {
        this.edge[this.index] = v;
        this.weight[this.index] = w;
        this.next[this.index] = this.head[u];
        ++this.index;
    }

    public boolean[] findAnswer(int n, int[][] edges) {
        int m = edges.length;
        this.edge = new int[m << 1];
        this.weight = new int[m << 1];
        this.next = new int[m << 1];
        this.head = new int[n];
        for (int i = 0; i < n; ++i) {
            this.head[i] = -1;
        }
        this.index = 0;
        for (int[] localEdge : edges) {
            int u = localEdge[0];
            int v = localEdge[1];
            int w = localEdge[2];
            this.add(u, v, w);
            this.add(v, u, w);
        }
        PriorityQueue<long[]> pq = new PriorityQueue<long[]>((a, b) -> a[1] < b[1] ? -1 : 1);
        long[] distances = new long[n];
        Arrays.fill(distances, 1000000000000L);
        pq.offer(new long[]{0L, 0L});
        distances[0] = 0L;
        while (!pq.isEmpty()) {
            int u;
            long[] cur = (long[])pq.poll();
            long distance = cur[1];
            if (distance > distances[u = (int)cur[0]]) continue;
            if (u == n - 1) break;
            int localIndex = this.head[u];
            while (localIndex != -1) {
                int w = this.weight[localIndex];
                long newDistance = distance + (long)w;
                int v = this.edge[localIndex];
                if (newDistance < distances[v]) {
                    distances[v] = newDistance;
                    pq.offer(new long[]{v, newDistance});
                }
                localIndex = this.next[localIndex];
            }
        }
        boolean[] ans = new boolean[m];
        if (distances[n - 1] >= 1000000000000L) {
            return ans;
        }
        this.dfs(distances, n - 1, -1, ans);
        return ans;
    }

    private void dfs(long[] distances, int u, int pre, boolean[] ans) {
        int localIndex = this.head[u];
        while (localIndex != -1) {
            int v = this.edge[localIndex];
            int w = this.weight[localIndex];
            int i = localIndex >> 1;
            if (distances[v] + (long)w == distances[u]) {
                ans[i] = true;
                if (v != pre) {
                    this.dfs(distances, v, u, ans);
                }
            }
            localIndex = this.next[localIndex];
        }
    }
}

