/*
 * Decompiled with CFR 0.152.
 */
package g0101_0200.s0126_word_ladder_ii;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Solution {
    public List<List<String>> findLadders(String beginWord, String endWord, List<String> wordList) {
        HashMap<String, Set<String>> graph = new HashMap<String, Set<String>>();
        int targetLength = this.bfs(graph, beginWord, endWord, wordList);
        ArrayList<List<String>> ans = new ArrayList<List<String>>();
        if (targetLength == 0) {
            return ans;
        }
        this.dfs(ans, new ArrayList<String>(), targetLength, beginWord, endWord, graph);
        return ans;
    }

    private int bfs(Map<String, Set<String>> graph, String beginWord, String endWord, List<String> wordList) {
        HashSet<String> wordSet = new HashSet<String>(wordList);
        if (!wordSet.contains(endWord)) {
            return 0;
        }
        wordSet.add(beginWord);
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(beginWord));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(endWord));
        HashSet<String> visited = new HashSet<String>();
        boolean isReversed = false;
        int length = 0;
        boolean found = false;
        while (!set1.isEmpty() && !found) {
            HashSet<String> newSet = new HashSet<String>();
            ++length;
            for (String word : set1) {
                visited.add(word);
                char[] arrWord = word.toCharArray();
                for (int i = 0; i < arrWord.length; ++i) {
                    char oldChar = arrWord[i];
                    for (int j = 0; j < 26; ++j) {
                        char newChar = (char)(97 + j);
                        if (newChar == oldChar) continue;
                        arrWord[i] = newChar;
                        String newWord = String.valueOf(arrWord);
                        if (!wordSet.contains(newWord)) continue;
                        if (set2.contains(newWord)) {
                            found = true;
                        }
                        if (visited.contains(newWord)) continue;
                        newSet.add(newWord);
                        if (!isReversed) {
                            graph.putIfAbsent(word, new HashSet());
                            graph.get(word).add(newWord);
                            continue;
                        }
                        graph.putIfAbsent(newWord, new HashSet());
                        graph.get(newWord).add(word);
                    }
                    arrWord[i] = oldChar;
                }
            }
            set1 = newSet;
            if (set1.size() <= set2.size()) continue;
            HashSet<String> tmpVisited = set1;
            set1 = set2;
            set2 = tmpVisited;
            isReversed = !isReversed;
        }
        if (!found) {
            return 0;
        }
        return length + 1;
    }

    private void dfs(List<List<String>> ans, List<String> path, int targetLength, String beginWord, String endWord, Map<String, Set<String>> graph) {
        path.add(beginWord);
        if (path.size() > targetLength) {
            path.remove(path.size() - 1);
            return;
        }
        if (beginWord.equals(endWord)) {
            ans.add(new ArrayList<String>(path));
            path.remove(path.size() - 1);
            return;
        }
        if (graph.containsKey(beginWord)) {
            for (String neighbor : graph.get(beginWord)) {
                this.dfs(ans, path, targetLength, neighbor, endWord, graph);
            }
        }
        path.remove(path.size() - 1);
    }
}

