/*
 * Decompiled with CFR 0.152.
 */
package g0501_0600.s0529_minesweeper;

public class Solution {
    private static final int[][] DIRECTION = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {-1, -1}, {-1, 1}, {1, -1}, {1, 1}};
    private int row;
    private int col;

    private void dfs(char[][] board, int row, int col) {
        if (row < 0 || row >= this.row || col < 0 || col >= this.col) {
            return;
        }
        if (board[row][col] == 'E') {
            int numOfMine = this.bfs(board, row, col);
            if (numOfMine != 0) {
                board[row][col] = (char)(numOfMine + 48);
                return;
            }
            board[row][col] = 66;
            for (int[] i : DIRECTION) {
                this.dfs(board, row + i[0], col + i[1]);
            }
        }
    }

    private int bfs(char[][] board, int row, int col) {
        int numOfMine = 0;
        for (int[] i : DIRECTION) {
            int newRow = row + i[0];
            int newCol = col + i[1];
            if (newRow < 0 || newRow >= this.row || newCol < 0 || newCol >= this.col || board[newRow][newCol] != 'M') continue;
            ++numOfMine;
        }
        return numOfMine;
    }

    public char[][] updateBoard(char[][] board, int[] c) {
        if (board[c[0]][c[1]] == 'M') {
            board[c[0]][c[1]] = 88;
            return board;
        }
        this.row = board.length;
        this.col = board[0].length;
        this.dfs(board, c[0], c[1]);
        return board;
    }
}

