/*
 * Decompiled with CFR 0.152.
 */
package g0601_0700.s0641_design_circular_deque;

public class MyCircularDeque {
    private final int[] data;
    private int front;
    private int rear;
    private int size;

    public MyCircularDeque(int k) {
        this.data = new int[k];
        this.front = 0;
        this.rear = k - 1;
        this.size = 0;
    }

    public boolean insertFront(int value) {
        if (this.size == this.data.length) {
            return false;
        }
        this.data[this.front] = value;
        this.front = (this.front + 1) % this.data.length;
        ++this.size;
        return true;
    }

    public boolean insertLast(int value) {
        if (this.size == this.data.length) {
            return false;
        }
        this.data[this.rear] = value;
        this.rear = (this.rear - 1 + this.data.length) % this.data.length;
        ++this.size;
        return true;
    }

    public boolean deleteFront() {
        if (this.size == 0) {
            return false;
        }
        this.front = (this.front - 1 + this.data.length) % this.data.length;
        --this.size;
        return true;
    }

    public boolean deleteLast() {
        if (this.size == 0) {
            return false;
        }
        this.rear = (this.rear + 1) % this.data.length;
        --this.size;
        return true;
    }

    public int getFront() {
        if (this.size == 0) {
            return -1;
        }
        return this.data[(this.front - 1 + this.data.length) % this.data.length];
    }

    public int getRear() {
        if (this.size == 0) {
            return -1;
        }
        return this.data[(this.rear + 1) % this.data.length];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.data.length;
    }
}

