/*
 * Decompiled with CFR 0.152.
 */
package g0701_0800.s0736_parse_lisp_expression;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Solution {
    private Exp buildTree(String exp) {
        Exp root;
        Exp cur = root = new Exp(null);
        for (int n = exp.length() - 1; n >= 0; --n) {
            int pre;
            char c = exp.charAt(n);
            if (c == ')') {
                Exp next = new Exp(cur);
                cur.exps.push(next);
                cur = next;
                continue;
            }
            if (c == '(') {
                cur.op = cur.exps.pop().op;
                cur = cur.parent;
                continue;
            }
            if (c == ' ') continue;
            for (pre = n; pre >= 0 && exp.charAt(pre) != '(' && exp.charAt(pre) != ' '; --pre) {
            }
            Exp next = new Exp(cur);
            next.op = exp.substring(pre + 1, n + 1);
            cur.exps.push(next);
            n = pre + 1;
        }
        return root.exps.pop();
    }

    public int evaluate(String exp) {
        return this.buildTree(exp).evaluate(new HashMap());
    }

    static class Exp {
        Deque<Exp> exps = new LinkedList<Exp>();
        String op;
        Exp parent;

        public Exp(Exp from) {
            this.parent = from;
        }

        private int evaluate(Map<String, Integer> vars) {
            if (this.op.equalsIgnoreCase("add")) {
                return this.exps.pop().evaluate(vars) + this.exps.pop().evaluate(vars);
            }
            if (this.op.equalsIgnoreCase("mult")) {
                return this.exps.pop().evaluate(vars) * this.exps.pop().evaluate(vars);
            }
            if (this.op.equalsIgnoreCase("let")) {
                HashMap<String, Integer> nextVars = new HashMap<String, Integer>(vars);
                while (this.exps.size() > 1) {
                    String varName = this.exps.pop().op;
                    int val = this.exps.pop().evaluate(nextVars);
                    nextVars.put(varName, val);
                }
                return this.exps.pop().evaluate(nextVars);
            }
            if (Character.isLetter(this.op.charAt(0))) {
                return vars.get(this.op);
            }
            return Integer.parseInt(this.op);
        }
    }
}

