/*
 * Decompiled with CFR 0.152.
 */
package g0701_0800.s0770_basic_calculator_iv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Solution {
    public List<String> basicCalculatorIV(String expression, String[] evalvars, int[] evalints) {
        HashMap<String, Integer> knownVars = new HashMap<String, Integer>();
        for (int i = 0; i < evalvars.length; ++i) {
            knownVars.put(evalvars[i], evalints[i]);
        }
        LinkedList<Expr> expressions = new LinkedList<Expr>();
        LinkedList<String> ops = new LinkedList<String>();
        for (String token : this.parseExpression(expression)) {
            if (Character.isDigit(token.charAt(0))) {
                expressions.push(new Expr("", Integer.parseInt(token)));
                continue;
            }
            if (token.equals("(")) {
                ops.push("(");
                continue;
            }
            if (token.equals(")")) {
                while (!ops.peek().equals("(")) {
                    this.doOneEval(ops, expressions);
                }
                ops.pop();
                continue;
            }
            if (token.equals("+") || token.equals("-") || token.equals("*")) {
                int rank = this.getRank(token);
                while (!ops.isEmpty() && !ops.peek().equals("(") && this.getRank(ops.peek()) >= rank) {
                    this.doOneEval(ops, expressions);
                }
                ops.push(token);
                continue;
            }
            if (knownVars.containsKey(token)) {
                expressions.push(new Expr("", (Integer)knownVars.get(token)));
                continue;
            }
            expressions.push(new Expr(token, 1));
        }
        while (!ops.isEmpty()) {
            this.doOneEval(ops, expressions);
        }
        Expr expr = (Expr)expressions.peek();
        ArrayList<String> output = new ArrayList<String>();
        for (String term : expr.terms.keySet()) {
            if (expr.terms.get(term) == 0) continue;
            output.add("" + expr.terms.get(term) + (term.equals("") ? "" : "*" + term));
        }
        output.sort((a, b) -> {
            int i;
            int aStar = 0;
            int bStar = 0;
            for (i = 0; i < a.length(); ++i) {
                if (a.charAt(i) != '*') continue;
                ++aStar;
            }
            for (i = 0; i < b.length(); ++i) {
                if (b.charAt(i) != '*') continue;
                ++bStar;
            }
            if (aStar != bStar) {
                return bStar - aStar;
            }
            return a.split("\\*", 2)[1].compareTo(b.split("\\*", 2)[1]);
        });
        return output;
    }

    private int getRank(String op) {
        if (op.equals("+") || op.equals("-")) {
            return 1;
        }
        return 2;
    }

    private List<String> parseExpression(String s) {
        ArrayList<String> output = new ArrayList<String>();
        for (String token : s.split(" ")) {
            int opening = 0;
            while (token.charAt(opening) == '(') {
                output.add("(");
                ++opening;
            }
            int closing = 0;
            while (token.charAt(token.length() - 1 - closing) == ')') {
                ++closing;
            }
            output.add(token.substring(opening, token.length() - closing));
            while (closing-- > 0) {
                output.add(")");
            }
        }
        return output;
    }

    private void doOneEval(LinkedList<String> ops, LinkedList<Expr> expressions) {
        Expr e2 = expressions.pop();
        Expr e1 = expressions.pop();
        Expr res = new Expr("", 0);
        String op = ops.pop();
        if (op.equals("+") || op.equals("-")) {
            int sign = op.equals("-") ? -1 : 1;
            res.terms = e1.terms;
            for (String term : e2.terms.keySet()) {
                res.terms.put(term, sign * e2.terms.get(term) + res.terms.getOrDefault(term, 0));
            }
        } else {
            for (String t1 : e1.terms.keySet()) {
                for (String t2 : e2.terms.keySet()) {
                    String resTerm = this.generateTerm(t1, t2);
                    res.terms.put(resTerm, e1.terms.get(t1) * e2.terms.get(t2) + res.terms.getOrDefault(resTerm, 0));
                }
            }
        }
        expressions.push(res);
    }

    private String generateTerm(String t1, String t2) {
        if (t1.equals("")) {
            return t2;
        }
        if (t2.equals("")) {
            return t1;
        }
        ArrayList parts = new ArrayList();
        Collections.addAll(parts, t1.split("\\*"));
        Collections.addAll(parts, t2.split("\\*"));
        Collections.sort(parts);
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part + "*");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static class Expr {
        public Map<String, Integer> terms = new HashMap<String, Integer>();

        public Expr(String term, int val) {
            this.terms.put(term, val);
        }
    }
}

