/*
 * Decompiled with CFR 0.152.
 */
package g0401_0500.s0480_sliding_window_median;

import java.util.Comparator;
import java.util.TreeSet;

public class Solution {
    public double[] medianSlidingWindow(int[] nums, int k) {
        if (nums == null || k <= 0) {
            throw new IllegalArgumentException("Input is invalid");
        }
        int len = nums.length;
        double[] result = new double[len - k + 1];
        if (k == 1) {
            for (int i = 0; i < len; ++i) {
                result[i] = nums[i];
            }
            return result;
        }
        Comparator comparator = (a, b) -> nums[a] != nums[b] ? Integer.compare(nums[a], nums[b]) : Integer.compare(a, b);
        TreeSet<Integer> smallNums = new TreeSet<Integer>(comparator.reversed());
        TreeSet<Integer> largeNums = new TreeSet<Integer>(comparator);
        for (int i = 0; i < len; ++i) {
            if (i >= k) {
                this.removeElement(smallNums, largeNums, i - k);
            }
            this.addElement(smallNums, largeNums, i);
            if (i < k - 1) continue;
            result[i - (k - 1)] = this.getMedian(smallNums, largeNums, nums);
        }
        return result;
    }

    private void addElement(TreeSet<Integer> smallNums, TreeSet<Integer> largeNums, int idx) {
        smallNums.add(idx);
        largeNums.add(smallNums.pollFirst());
        if (smallNums.size() < largeNums.size()) {
            smallNums.add(largeNums.pollFirst());
        }
    }

    private void removeElement(TreeSet<Integer> smallNums, TreeSet<Integer> largeNums, int idx) {
        if (largeNums.contains(idx)) {
            largeNums.remove(idx);
            if (smallNums.size() == largeNums.size() + 2) {
                largeNums.add(smallNums.pollFirst());
            }
        } else {
            smallNums.remove(idx);
            if (smallNums.size() < largeNums.size()) {
                smallNums.add(largeNums.pollFirst());
            }
        }
    }

    private double getMedian(TreeSet<Integer> smallNums, TreeSet<Integer> largeNums, int[] nums) {
        if (smallNums.size() == largeNums.size()) {
            return ((double)nums[smallNums.first()] + (double)nums[largeNums.first()]) / 2.0;
        }
        return nums[smallNums.first()];
    }
}

