/*
 * Decompiled with CFR 0.152.
 */
package g0101_0200.s0146_lru_cache;

import java.util.HashMap;
import java.util.Map;

public class LRUCache {
    private int capacity;
    private Map<Integer, LruCacheNode> cacheMap = new HashMap<Integer, LruCacheNode>();
    private LruCacheNode head;
    private LruCacheNode tail;

    public LRUCache(int cap) {
        this.capacity = cap;
    }

    public int get(int key) {
        LruCacheNode val = this.cacheMap.get(key);
        if (val == null) {
            return -1;
        }
        this.moveToHead(val);
        return val.value;
    }

    public void put(int key, int value) {
        LruCacheNode valNode = this.cacheMap.get(key);
        if (valNode != null) {
            valNode.value = value;
            this.moveToHead(valNode);
        } else if (this.cacheMap.size() < this.capacity) {
            if (this.cacheMap.size() == 0) {
                LruCacheNode node = new LruCacheNode(key, value);
                this.cacheMap.put(key, node);
                this.head = node;
                this.tail = node;
            } else {
                LruCacheNode node = new LruCacheNode(key, value);
                this.cacheMap.put(key, node);
                node.next = this.head;
                this.head.prev = node;
                this.head = node;
            }
        } else {
            LruCacheNode last = this.tail;
            this.tail = last.prev;
            if (this.tail != null) {
                this.tail.next = null;
            }
            this.cacheMap.remove(last.key);
            if (this.cacheMap.size() == 0) {
                this.head = null;
            }
            this.put(key, value);
        }
    }

    private void moveToHead(LruCacheNode node) {
        LruCacheNode next;
        if (node == this.head) {
            return;
        }
        if (node == this.tail) {
            this.tail = node.prev;
        }
        LruCacheNode prev = node.prev;
        prev.next = next = node.next;
        if (next != null) {
            next.prev = prev;
        }
        node.prev = null;
        node.next = this.head;
        this.head.prev = node;
        this.head = node;
    }

    private static class LruCacheNode {
        int key;
        int value;
        LruCacheNode prev;
        LruCacheNode next;

        public LruCacheNode(int k, int v) {
            this.key = k;
            this.value = v;
        }
    }
}

