/*
 * Decompiled with CFR 0.152.
 */
package g0801_0900.s0874_walking_robot_simulation;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class Solution {
    public int robotSim(int[] commands, int[][] obstacles) {
        int direction = 1;
        int x = 0;
        int y = 0;
        int maxDis = 0;
        HashMap<Integer, TreeSet<Integer>> xMap = new HashMap<Integer, TreeSet<Integer>>(obstacles.length);
        HashMap<Integer, TreeSet<Integer>> yMap = new HashMap<Integer, TreeSet<Integer>>(obstacles.length);
        for (int[] xy : obstacles) {
            xMap.computeIfAbsent(xy[0], k -> new TreeSet()).add(xy[1]);
            yMap.computeIfAbsent(xy[1], k -> new TreeSet()).add(xy[0]);
        }
        for (int cmd : commands) {
            if (cmd == -1) {
                direction += 3;
                direction %= 4;
                continue;
            }
            if (cmd == -2) {
                ++direction;
                direction %= 4;
                continue;
            }
            Integer next = null;
            switch (direction) {
                case 0: {
                    x = this.getXPlusOne(x, y, yMap, cmd, next);
                    break;
                }
                case 1: {
                    y = this.getXPlusOne(y, x, xMap, cmd, next);
                    break;
                }
                case 2: {
                    x = this.getXMinusOne(x, y, yMap, cmd, next);
                    break;
                }
                case 3: {
                    y = this.getXMinusOne(y, x, xMap, cmd, next);
                    break;
                }
            }
            maxDis = Math.max(maxDis, x * x + y * y);
        }
        return maxDis;
    }

    private int getXMinusOne(int x, int y, Map<Integer, TreeSet<Integer>> yMap, int cmd, Integer next) {
        if (yMap.containsKey(y)) {
            next = yMap.get(y).floor(x - 1);
        }
        x = next != null ? Math.max(x - cmd, next + 1) : (x -= cmd);
        return x;
    }

    private int getXPlusOne(int x, int y, Map<Integer, TreeSet<Integer>> yMap, int cmd, Integer next) {
        if (yMap.containsKey(y)) {
            next = yMap.get(y).ceiling(x + 1);
        }
        x = next != null ? Math.min(x + cmd, next - 1) : (x += cmd);
        return x;
    }
}

