/*
 * Decompiled with CFR 0.152.
 */
package g1301_1400.s1319_number_of_operations_to_make_network_connected;

import java.util.Arrays;

public class Solution {
    private static final int IMPOSSIBLE_TO_CONNECT = -1;
    private int disconnectedComputers;
    private int[] parent;
    private int[] rank;

    public int makeConnected(int totalNumberOfComputers, int[][] connections) {
        if (connections.length < totalNumberOfComputers - 1) {
            return -1;
        }
        this.disconnectedComputers = totalNumberOfComputers;
        this.rank = new int[totalNumberOfComputers];
        this.parent = new int[totalNumberOfComputers];
        Arrays.setAll(this.parent, intFromZero -> intFromZero++);
        for (int[] connection : connections) {
            this.unionFind(connection[0], connection[1]);
        }
        return this.disconnectedComputers - 1;
    }

    private void unionFind(int first, int second) {
        int parentSecond;
        int parentFirst = this.findParent(first);
        if (parentFirst != (parentSecond = this.findParent(second))) {
            this.joinByRank(parentFirst, parentSecond);
            --this.disconnectedComputers;
        }
    }

    private int findParent(int index) {
        if (this.parent[index] != index) {
            this.parent[index] = this.findParent(this.parent[index]);
        }
        return this.parent[index];
    }

    private void joinByRank(int first, int second) {
        if (this.rank[first] < this.rank[second]) {
            this.parent[first] = second;
        } else if (this.rank[second] < this.rank[first]) {
            this.parent[second] = first;
        } else {
            this.parent[first] = second;
            int n = second;
            this.rank[n] = this.rank[n] + 1;
        }
    }
}

