/*
 * Decompiled with CFR 0.152.
 */
package g1401_1500.s1496_path_crossing;

import java.util.ArrayDeque;
import java.util.Objects;

public class Solution {
    public boolean isPathCrossing(String path) {
        ArrayDeque<Coord> visited = new ArrayDeque<Coord>();
        visited.add(new Coord(0, 0));
        for (char c : path.toCharArray()) {
            Coord nextStep;
            Coord last = (Coord)visited.peek();
            if (c == 'N') {
                nextStep = new Coord(last.x, last.y + 1);
                if (visited.contains(nextStep)) {
                    return true;
                }
                visited.add(nextStep);
                continue;
            }
            if (c == 'S') {
                nextStep = new Coord(last.x, last.y - 1);
                if (visited.contains(nextStep)) {
                    return true;
                }
                visited.add(nextStep);
                continue;
            }
            if (c == 'E') {
                nextStep = new Coord(last.x - 1, last.y);
                if (visited.contains(nextStep)) {
                    return true;
                }
                visited.add(nextStep);
                continue;
            }
            if (c != 'W') continue;
            nextStep = new Coord(last.x + 1, last.y);
            if (visited.contains(nextStep)) {
                return true;
            }
            visited.add(nextStep);
        }
        return false;
    }

    private static class Coord {
        int x;
        int y;

        public Coord(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Coord coord = (Coord)o;
            return this.x == coord.x && this.y == coord.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }
}

