/*
 * Decompiled with CFR 0.152.
 */
package g1901_2000.s1912_design_movie_rental_system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class MovieRentingSystem {
    private HashMap<Integer, TreeSet<Point>> unrentedMovies = new HashMap();
    private HashMap<String, Integer> shopMovieToPrice = new HashMap();
    private Comparator<Point> comparator = (o1, o2) -> {
        if (o1.price != o2.price) {
            return Integer.compare(o1.price, o2.price);
        }
        if (o1.shop != o2.shop) {
            return Integer.compare(o1.shop, o2.shop);
        }
        return Integer.compare(o1.movie, o2.movie);
    };
    private TreeSet<Point> rented = new TreeSet<Point>(this.comparator);

    public MovieRentingSystem(int n, int[][] entries) {
        for (int[] entry : entries) {
            int shop = entry[0];
            int movie = entry[1];
            int price = entry[2];
            this.unrentedMovies.putIfAbsent(movie, new TreeSet<Point>(this.comparator));
            this.unrentedMovies.get(movie).add(new Point(movie, shop, price));
            this.shopMovieToPrice.put(shop + "+" + movie, price);
        }
    }

    public List<Integer> search(int movie) {
        if (!this.unrentedMovies.containsKey(movie)) {
            return new ArrayList<Integer>();
        }
        Iterator<Point> iterator = this.unrentedMovies.get(movie).iterator();
        ArrayList<Integer> listOfShops = new ArrayList<Integer>();
        while (iterator.hasNext() && listOfShops.size() < 5) {
            listOfShops.add(iterator.next().shop);
        }
        return listOfShops;
    }

    public void rent(int shop, int movie) {
        int price = this.shopMovieToPrice.get(shop + "+" + movie);
        this.rented.add(new Point(movie, shop, price));
        this.unrentedMovies.get(movie).remove(new Point(movie, shop, price));
    }

    public void drop(int shop, int movie) {
        int price = this.shopMovieToPrice.get(shop + "+" + movie);
        this.rented.remove(new Point(movie, shop, price));
        this.unrentedMovies.get(movie).add(new Point(movie, shop, price));
    }

    public List<List<Integer>> report() {
        ArrayList<List<Integer>> ans = new ArrayList<List<Integer>>();
        Iterator<Point> iterator = this.rented.iterator();
        while (iterator.hasNext() && ans.size() < 5) {
            Point point = iterator.next();
            ans.add(Arrays.asList(point.shop, point.movie));
        }
        return ans;
    }

    private static class Point {
        int movie;
        int shop;
        int price;

        public Point(int movie, int shop, int price) {
            this.movie = movie;
            this.shop = shop;
            this.price = price;
        }
    }
}

