/*
 * Decompiled with CFR 0.152.
 */
package g1901_2000.s1932_merge_bsts_to_create_single_bst;

import com_github_leetcode.TreeNode;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Solution {
    private static final Map<Integer, TreeNode> ROOT_VALS = new HashMap<Integer, TreeNode>();

    public TreeNode canMerge(List<TreeNode> trees) {
        TreeNode root = this.findRoot(trees);
        if (root == null) {
            return null;
        }
        for (TreeNode t : trees) {
            ROOT_VALS.put(t.val, t);
        }
        this.bfs(root);
        if (!this.isValidBST(root) || ROOT_VALS.size() != 1) {
            return null;
        }
        return root;
    }

    private TreeNode findRoot(List<TreeNode> trees) {
        TreeNode root = null;
        HashMap<Integer, Integer> valCnts = new HashMap<Integer, Integer>();
        for (TreeNode t : trees) {
            valCnts.put(t.val, valCnts.getOrDefault(t.val, 0) + 1);
            if (t.left != null) {
                valCnts.put(t.left.val, valCnts.getOrDefault(t.left.val, 0) + 1);
            }
            if (t.right == null) continue;
            valCnts.put(t.right.val, valCnts.getOrDefault(t.right.val, 0) + 1);
        }
        for (TreeNode t : trees) {
            if ((Integer)valCnts.get(t.val) != 1) continue;
            if (root == null) {
                root = t;
                continue;
            }
            return null;
        }
        return root;
    }

    private void bfs(TreeNode root) {
        ArrayDeque<TreeNode> q = new ArrayDeque<TreeNode>();
        q.offer(root);
        while (!q.isEmpty()) {
            int size = q.size();
            for (int i = 0; i < size; ++i) {
                TreeNode toConnect;
                TreeNode parent = (TreeNode)q.poll();
                if (parent.left != null && ROOT_VALS.containsKey(parent.left.val)) {
                    toConnect = ROOT_VALS.get(parent.left.val);
                    ROOT_VALS.remove(toConnect.val);
                    parent.left = toConnect;
                    q.offer(parent.left);
                }
                if (parent.right == null || !ROOT_VALS.containsKey(parent.right.val)) continue;
                toConnect = ROOT_VALS.get(parent.right.val);
                ROOT_VALS.remove(toConnect.val);
                parent.right = toConnect;
                q.offer(parent.right);
            }
        }
    }

    private boolean isValidBST(TreeNode root) {
        return this.isValidBST(root, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private boolean isValidBST(TreeNode root, int min, int max) {
        if (root == null) {
            return true;
        }
        if (root.val <= min || root.val >= max) {
            return false;
        }
        return this.isValidBST(root.left, min, root.val) && this.isValidBST(root.right, root.val, max);
    }
}

