/*
 * Decompiled with CFR 0.152.
 */
package g2201_2300.s2296_design_a_text_editor;

public class TextEditor {
    private final StringBuilder sb = new StringBuilder();
    private int cursor = 0;

    public void addText(String text) {
        this.sb.insert(this.cursor, text);
        this.cursor += text.length();
    }

    public int deleteText(int k) {
        int prevPos = this.cursor;
        if (this.cursor - k >= 0) {
            this.cursor -= k;
            this.sb.delete(this.cursor, this.cursor + k);
        } else {
            this.sb.delete(0, this.cursor);
            this.cursor = 0;
        }
        return prevPos - this.cursor;
    }

    public String cursorLeft(int k) {
        this.cursor = Math.max(this.cursor - k, 0);
        return this.sb.substring(Math.max(this.cursor - 10, 0), this.cursor);
    }

    public String cursorRight(int k) {
        this.cursor = Math.min(this.cursor + k, this.sb.length());
        return this.sb.substring(Math.max(this.cursor - 10, 0), this.cursor);
    }
}

