/*
 * Decompiled with CFR 0.152.
 */
package g2601_2700.s2646_minimize_the_total_price_of_the_trips;

import java.util.ArrayList;
import java.util.List;

public class Solution {
    private List<Integer>[] graph;
    private int[] count;

    public int minimumTotalPrice(int n, int[][] edges, int[] price, int[][] trips) {
        this.graph = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            this.graph[i] = new ArrayList<Integer>();
        }
        for (int[] e : edges) {
            this.graph[e[0]].add(e[1]);
            this.graph[e[1]].add(e[0]);
        }
        this.count = new int[n];
        for (int[] t : trips) {
            this.getPath(t[0], -1, t[1]);
        }
        int[] maxSum = this.getMax(0, -1, price);
        int res = -Math.max(maxSum[0], maxSum[1]) / 2;
        for (int i = 0; i < n; ++i) {
            res += this.count[i] * price[i];
        }
        return res;
    }

    private int[] getMax(int current, int prev, int[] price) {
        int[] res = new int[]{price[current] * this.count[current], 0};
        for (int v : this.graph[current]) {
            if (v == prev) continue;
            int[] curr = this.getMax(v, current, price);
            res[0] = res[0] + curr[1];
            res[1] = res[1] + Math.max(curr[0], curr[1]);
        }
        return res;
    }

    private boolean getPath(int current, int prev, int search) {
        if (current == search) {
            int n = current;
            this.count[n] = this.count[n] + 1;
            return true;
        }
        for (int v : this.graph[current]) {
            if (v == prev || !this.getPath(v, current, search)) continue;
            int n = current;
            this.count[n] = this.count[n] + 1;
            return true;
        }
        return false;
    }
}

