/*
 * Decompiled with CFR 0.152.
 */
package g0201_0300.s0212_word_search_ii;

import g0201_0300.s0212_word_search_ii.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Solution {
    private Tree root;

    public List<String> findWords(char[][] board, String[] words) {
        if (board.length < 1 || board[0].length < 1) {
            return Collections.emptyList();
        }
        this.root = new Tree();
        for (String word : words) {
            Tree.addWord(this.root, word);
        }
        ArrayList<String> collected = new ArrayList<String>();
        for (int i = 0; i != board.length; ++i) {
            for (int j = 0; j != board[0].length; ++j) {
                this.dfs(board, i, j, this.root, collected);
            }
        }
        return collected;
    }

    private void dfs(char[][] board, int i, int j, Tree cur, List<String> collected) {
        char c = board[i][j];
        if (c == '-') {
            return;
        }
        if ((cur = cur.getChild(c)) == null) {
            return;
        }
        if (cur.end != null) {
            String s = cur.end;
            collected.add(s);
            cur.end = null;
            if (cur.len() == 0) {
                Tree.deleteWord(this.root, s);
            }
        }
        board[i][j] = 45;
        if (i > 0) {
            this.dfs(board, i - 1, j, cur, collected);
        }
        if (i + 1 < board.length) {
            this.dfs(board, i + 1, j, cur, collected);
        }
        if (j > 0) {
            this.dfs(board, i, j - 1, cur, collected);
        }
        if (j + 1 < board[0].length) {
            this.dfs(board, i, j + 1, cur, collected);
        }
        board[i][j] = c;
    }
}

