/*
 * Decompiled with CFR 0.152.
 */
package g0401_0500.s0432_all_oone_data_structure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AllOne {
    private Bucket head = new Bucket(Integer.MIN_VALUE);
    private Bucket tail;
    private Map<Integer, Bucket> countBucketMap;
    private Map<String, Integer> keyCountMap;

    public AllOne() {
        this.head.next = this.tail = new Bucket(Integer.MAX_VALUE);
        this.tail.pre = this.head;
        this.countBucketMap = new HashMap<Integer, Bucket>();
        this.keyCountMap = new HashMap<String, Integer>();
    }

    public void inc(String key) {
        if (this.keyCountMap.containsKey(key)) {
            this.changeKey(key, 1);
        } else {
            this.keyCountMap.put(key, 1);
            if (this.head.next.count != 1) {
                this.addBucketAfter(new Bucket(1), this.head);
            }
            this.head.next.keySet.add(key);
            this.countBucketMap.put(1, this.head.next);
        }
    }

    public void dec(String key) {
        if (this.keyCountMap.containsKey(key)) {
            int count = this.keyCountMap.get(key);
            if (count == 1) {
                this.keyCountMap.remove(key);
                this.removeKeyFromBucket(this.countBucketMap.get(count), key);
            } else {
                this.changeKey(key, -1);
            }
        }
    }

    public String getMaxKey() {
        return this.tail.pre == this.head ? "" : this.tail.pre.keySet.iterator().next();
    }

    public String getMinKey() {
        return this.head.next == this.tail ? "" : this.head.next.keySet.iterator().next();
    }

    private void changeKey(String key, int offset) {
        Bucket newBucket;
        int count = this.keyCountMap.get(key);
        this.keyCountMap.put(key, count + offset);
        Bucket curBucket = this.countBucketMap.get(count);
        if (this.countBucketMap.containsKey(count + offset)) {
            newBucket = this.countBucketMap.get(count + offset);
        } else {
            newBucket = new Bucket(count + offset);
            this.countBucketMap.put(count + offset, newBucket);
            this.addBucketAfter(newBucket, offset == 1 ? curBucket : curBucket.pre);
        }
        newBucket.keySet.add(key);
        this.removeKeyFromBucket(curBucket, key);
    }

    private void removeKeyFromBucket(Bucket bucket, String key) {
        bucket.keySet.remove(key);
        if (bucket.keySet.isEmpty()) {
            this.removeBucketFromList(bucket);
            this.countBucketMap.remove(bucket.count);
        }
    }

    private void removeBucketFromList(Bucket bucket) {
        bucket.pre.next = bucket.next;
        bucket.next.pre = bucket.pre;
        bucket.next = null;
        bucket.pre = null;
    }

    private void addBucketAfter(Bucket newBucket, Bucket preBucket) {
        newBucket.pre = preBucket;
        newBucket.next = preBucket.next;
        preBucket.next.pre = newBucket;
        preBucket.next = newBucket;
    }

    private static class Bucket {
        int count;
        Set<String> keySet;
        Bucket next;
        Bucket pre;

        public Bucket(int cnt) {
            this.count = cnt;
            this.keySet = new HashSet<String>();
        }
    }
}

