/*
 * Decompiled with CFR 0.152.
 */
package g0601_0700.s0648_replace_words;

import java.util.List;

public class Solution {
    public String replaceWords(List<String> dictionary, String sentence) {
        Trie trie = new Trie();
        dictionary.forEach(trie::insert);
        CharSequence[] allWords = sentence.split(" ");
        for (int i = 0; i < allWords.length; ++i) {
            allWords[i] = trie.getRootForWord((String)allWords[i]);
        }
        return String.join((CharSequence)" ", allWords);
    }

    static class Trie {
        Node root = new Node();

        public void insert(String word) {
            Node node = this.root;
            for (int i = 0; i < word.length(); ++i) {
                if (!node.containsKey(word.charAt(i))) {
                    node.put(word.charAt(i), new Node());
                }
                node = node.get(word.charAt(i));
            }
            node.setWordCompleted(true);
        }

        public String getRootForWord(String word) {
            Node node = this.root;
            StringBuilder rootWord = new StringBuilder();
            for (int i = 0; i < word.length(); ++i) {
                if (node.containsKey(word.charAt(i))) {
                    rootWord.append(word.charAt(i));
                    node = node.get(word.charAt(i));
                    if (!node.isWordCompleted()) continue;
                    return rootWord.toString();
                }
                return word;
            }
            return word;
        }
    }

    static class Node {
        Node[] links = new Node[26];
        boolean wordCompleted;

        Node() {
        }

        public boolean containsKey(char ch) {
            return this.links[ch - 97] != null;
        }

        public void put(char ch, Node node) {
            this.links[ch - 97] = node;
        }

        public Node get(char ch) {
            return this.links[ch - 97];
        }

        public boolean isWordCompleted() {
            return this.wordCompleted;
        }

        public void setWordCompleted(boolean flag) {
            this.wordCompleted = flag;
        }
    }
}

