/*
 * Decompiled with CFR 0.152.
 */
package g2201_2300.s2286_booking_concert_tickets_in_groups;

import java.util.ArrayDeque;
import java.util.Arrays;

public class BookMyShow {
    private final int n;
    private final int m;
    private final int[] max;
    private final long[] total;
    private final int[] numZerosRight;
    private final int[] numZerosLeft;

    public BookMyShow(int n, int m) {
        this.n = BookMyShow.nextPow2(n);
        this.m = m;
        this.max = new int[this.n * 2 - 1];
        this.total = new long[this.n * 2 - 1];
        this.numZerosRight = new int[this.n + 2];
        this.numZerosLeft = new int[this.n + 2];
        Arrays.fill(this.max, this.n - 1, this.n + n - 1, m);
        Arrays.fill(this.total, this.n - 1, this.n + n - 1, (long)m);
        int i = this.n - 2;
        int i1 = i * 2 + 1;
        int i2 = i * 2 + 2;
        while (i >= 0) {
            this.max[i] = Math.max(this.max[i1], this.max[i2]);
            this.total[i] = this.total[i1] + this.total[i2];
            --i;
            i1 -= 2;
            i2 -= 2;
        }
    }

    public int[] gather(int k, int maxRow) {
        int mostLeft = this.mostLeft(0, 0, this.n, k, maxRow + 1);
        if (mostLeft == -1) {
            return new int[0];
        }
        int v = this.n - 1 + mostLeft;
        int[] ans = new int[]{mostLeft, this.m - this.max[v]};
        int n = v;
        this.max[n] = this.max[n] - k;
        int n2 = v;
        this.total[n2] = this.total[n2] - (long)k;
        while (v != 0) {
            v = (v - 1) / 2;
            this.max[v] = Math.max(this.max[v * 2 + 1], this.max[v * 2 + 2]);
            this.total[v] = this.total[v * 2 + 1] + this.total[v * 2 + 2];
        }
        return ans;
    }

    private int mostLeft(int v, int l, int r, int k, int qr) {
        if (l >= qr || this.max[v] < k) {
            return -1;
        }
        if (l == r - 1) {
            return l;
        }
        int mid = (l + r) / 2;
        int left = this.mostLeft(v * 2 + 1, l, mid, k, qr);
        if (left != -1) {
            return left;
        }
        return this.mostLeft(v * 2 + 2, mid, r, k, qr);
    }

    public boolean scatter(int k, int maxRow) {
        int v;
        long sum = this.total(0, 0, this.n, maxRow + 1);
        if (sum < (long)k) {
            return false;
        }
        int i = 0;
        ArrayDeque<Integer> deque = new ArrayDeque<Integer>();
        while (k != 0) {
            i = i + this.numZerosRight[i] + 1;
            v = this.n - 1 + i - 1;
            int spent = Math.min(k, this.max[v]);
            k -= spent;
            int n = v;
            this.max[n] = this.max[n] - spent;
            int n2 = v;
            this.total[n2] = this.total[n2] - (long)spent;
            if (this.max[v] == 0) {
                int n3 = i - this.numZerosLeft[i] - 1;
                this.numZerosRight[n3] = this.numZerosRight[n3] + (this.numZerosRight[i] + 1);
                int n4 = i + this.numZerosRight[i] + 1;
                this.numZerosLeft[n4] = this.numZerosLeft[n4] + (this.numZerosLeft[i] + 1);
            }
            if (v == 0) continue;
            v = (v - 1) / 2;
            if (!deque.isEmpty() && (Integer)deque.peekLast() == v) continue;
            deque.addLast(v);
        }
        while (!deque.isEmpty()) {
            v = (Integer)deque.pollFirst();
            this.max[v] = Math.max(this.max[v * 2 + 1], this.max[v * 2 + 2]);
            this.total[v] = this.total[v * 2 + 1] + this.total[v * 2 + 2];
            if (v == 0) continue;
            v = (v - 1) / 2;
            if (!deque.isEmpty() && (Integer)deque.peekLast() == v) continue;
            deque.addLast(v);
        }
        return true;
    }

    private long total(int v, int l, int r, int qr) {
        if (l >= qr) {
            return 0L;
        }
        if (r <= qr) {
            return this.total[v];
        }
        int mid = (l + r) / 2;
        return this.total(v * 2 + 1, l, mid, qr) + this.total(v * 2 + 2, mid, r, qr);
    }

    private static int nextPow2(int n) {
        if ((n & n - 1) == 0) {
            return n;
        }
        return Integer.highestOneBit(n) << 1;
    }
}

