/*
 * Decompiled with CFR 0.152.
 */
package g0401_0500.s0407_trapping_rain_water_ii;

import java.util.Objects;
import java.util.PriorityQueue;

public class Solution {
    private int water;
    private boolean[][] visited1;

    public int trapRainWater(int[][] heightMap) {
        if (heightMap.length == 0) {
            return 0;
        }
        PriorityQueue<Cell> walls = new PriorityQueue<Cell>();
        this.water = 0;
        this.visited1 = new boolean[heightMap.length][heightMap[0].length];
        int rows = heightMap.length;
        int cols = heightMap[0].length;
        for (int c = 0; c < cols; ++c) {
            walls.add(new Cell(0, c, heightMap[0][c]));
            walls.add(new Cell(rows - 1, c, heightMap[rows - 1][c]));
            this.visited1[0][c] = true;
            this.visited1[rows - 1][c] = true;
        }
        for (int r = 1; r < rows - 1; ++r) {
            walls.add(new Cell(r, 0, heightMap[r][0]));
            walls.add(new Cell(r, cols - 1, heightMap[r][cols - 1]));
            this.visited1[r][0] = true;
            this.visited1[r][cols - 1] = true;
        }
        while (!walls.isEmpty()) {
            Cell min = (Cell)walls.poll();
            this.visit(heightMap, min, walls);
        }
        return this.water;
    }

    private void visit(int[][] height, Cell start, PriorityQueue<Cell> walls) {
        this.fill(height, start.row + 1, start.col, walls, start.value);
        this.fill(height, start.row - 1, start.col, walls, start.value);
        this.fill(height, start.row, start.col + 1, walls, start.value);
        this.fill(height, start.row, start.col - 1, walls, start.value);
    }

    private void fill(int[][] height, int row, int col, PriorityQueue<Cell> walls, int min) {
        if (row >= 0 && col >= 0 && row < height.length && col < height[0].length && !this.visited1[row][col]) {
            if (height[row][col] >= min) {
                walls.add(new Cell(row, col, height[row][col]));
                this.visited1[row][col] = true;
            } else {
                this.water += min - height[row][col];
                this.visited1[row][col] = true;
                this.fill(height, row + 1, col, walls, min);
                this.fill(height, row - 1, col, walls, min);
                this.fill(height, row, col + 1, walls, min);
                this.fill(height, row, col - 1, walls, min);
            }
        }
    }

    private static class Cell
    implements Comparable<Cell> {
        private int row;
        private int col;
        private int value;

        public Cell(int r, int c, int v) {
            this.row = r;
            this.col = c;
            this.value = v;
        }

        @Override
        public int compareTo(Cell other) {
            return this.value - other.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cell cell = (Cell)o;
            return this.row == cell.row && this.col == cell.col && this.value == cell.value;
        }

        public int hashCode() {
            return Objects.hash(this.row, this.col, this.value);
        }
    }
}

