/*
 * Decompiled with CFR 0.152.
 */
package g2401_2500.s2497_maximum_star_sum_of_a_graph;

import java.util.PriorityQueue;

public class Solution {
    private PriorityQueue<Integer>[] graphNodeIdToNodeValues;

    public int maxStarSum(int[] nodeValues, int[][] edges, int maxNumberOfEdges) {
        int totalNodes = nodeValues.length;
        this.graphNodeIdToNodeValues = new PriorityQueue[totalNodes];
        for (int i = 0; i < totalNodes; ++i) {
            this.graphNodeIdToNodeValues[i] = new PriorityQueue();
        }
        for (int[] edge : edges) {
            this.addEdgeEndingWithValueOfNode(nodeValues, edge[0], edge[1], maxNumberOfEdges);
            this.addEdgeEndingWithValueOfNode(nodeValues, edge[1], edge[0], maxNumberOfEdges);
        }
        return this.calculateMaxStarSum(nodeValues, totalNodes);
    }

    private void addEdgeEndingWithValueOfNode(int[] nodeValues, int fromNode, int toNode, int maxNumberOfEdges) {
        if (nodeValues[toNode] > 0 && this.graphNodeIdToNodeValues[fromNode].size() < maxNumberOfEdges) {
            this.graphNodeIdToNodeValues[fromNode].add(nodeValues[toNode]);
        } else if (!this.graphNodeIdToNodeValues[fromNode].isEmpty() && this.graphNodeIdToNodeValues[fromNode].peek() < nodeValues[toNode]) {
            this.graphNodeIdToNodeValues[fromNode].poll();
            this.graphNodeIdToNodeValues[fromNode].add(nodeValues[toNode]);
        }
    }

    private int calculateMaxStarSum(int[] nodeValues, int totalNodes) {
        int maxStarSum = Integer.MIN_VALUE;
        for (int i = 0; i < totalNodes; ++i) {
            int sum = nodeValues[i];
            for (int value : this.graphNodeIdToNodeValues[i]) {
                sum += value;
            }
            maxStarSum = Math.max(maxStarSum, sum);
        }
        return maxStarSum;
    }
}

